/*
 * WaitCondition.h
 *
 *  Created on: 22.03.2011
 *      Author: hausding
 */

#ifndef ODEMX_SYNC_WAITCONDITION_INCLUDED
#define ODEMX_SYNC_WAITCONDITION_INCLUDED

#include <odemx/setup.h>

#ifdef ODEMX_USE_CONTINUOUS

#include <odemx/base/continuous/StateEvent.h>
#include <odemx/synchronization/Memory.h>
#include <odemx/simml/Monitor.h>

namespace odemx {

namespace synchronization {

class Monitor;

class WaitCondition: public base::continuous::StateEvent, public Memory {
public:
	WaitCondition(base::Simulation& sim, const data::Label& label,
			std::vector<Monitor*>* monitors, MemoryObserver* obs = 0);
	virtual ~WaitCondition();
	virtual bool isAvailable();
	virtual void action();

private:
	std::vector<Monitor*>* getMonitors();
	void addWaitCondition(Monitor* monitor);
	void addWaitCondtionAtAll(std::vector<Monitor*>* monitors);
	void removeWaitCondition(Monitor* monitor);
	void removeWaitConditionAtAll();
	std::vector<Monitor*>* monitors;
};

}

}

#endif /* ODEMX_USE_CONTINUOUS */

#endif /* ODEMX_SYNC_WAITCONDITION_INCLUDED */
