/*
 * ValueTypeT.h
 *
 *  Created on: 18.01.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_VALUETYPET_INCLUDED
#define ODEMX_SIMML_VALUETYPET_INCLUDED

#include <odemx/simml/Monitored.h>

namespace odemx {

namespace simml {

template<typename T = bool> class ValueType {
public:
	ValueType();
	ValueType(const T& src);
	ValueType(const ValueType<T>& src);
	virtual ~ValueType();

	operator T() const;
	ValueType<T>& operator=(const T& src);
	ValueType<T>& operator=(const ValueType<T>& src);
	ValueType<T>& operator+=(const T& src);

private:
	T value;
};

template<> class ValueType<std::string> : public std::string {
public:
	ValueType();
	ValueType(const char* chr);
	ValueType(const std::string& src);
	ValueType(const ValueType<std::string>& src);
	virtual ~ValueType();

	//ValueType& operator=(char* const src);
	//ValueType& operator=(const std::string& src);
	ValueType& operator=(const ValueType<std::string>& src);
	ValueType& operator+=(char* const src);
};

}

}

#endif /* ODEMX_SIMML_VALUETYPET_INCLUDED */
