/*
 * ValueTypeT.cpp
 *
 *  Created on: 18.01.2011
 *      Author: hausding
 */

#include <odemx/simml/ValueTypeT.h>

namespace odemx {

namespace simml {

template<typename T> ValueType<T>::ValueType() {
}

template<typename T> ValueType<T>::ValueType(const T& src) :
	value(src) {
}

template<typename T> ValueType<T>::ValueType(const ValueType<T>& src) :
	value(src) {
}

template<typename T> ValueType<T>::~ValueType() {
	// TODO Auto-generated destructor stub
}

template<typename T> ValueType<T>::operator T() const {
	return value;
}

template<typename T> ValueType<T>& ValueType<T>::operator=(const T& src) {
	value = src;
	return *this;
}

template<typename T> ValueType<T>& ValueType<T>::operator=(
		const ValueType<T>& src) {
	value = src.value;
	return *this;
}

template<typename T> ValueType<T>& ValueType<T>::operator+=(const T& src) {
	value += src;
	return *this;
}

inline ValueType<std::string>::ValueType() :
	std::string() {
}

inline ValueType<std::string>::ValueType(const char* chr) :
	std::string(chr) {
}

inline ValueType<std::string>::ValueType(const std::string& src) :
	std::string(src) {
}

inline ValueType<std::string>::ValueType(const ValueType<std::string>& src) :
	std::string(src) {
}

inline ValueType<std::string>::~ValueType() {
	// TODO Auto-generated destructor stub
}

//inline ValueType<std::string>& ValueType<std::string>::operator=(
//		char* const src) {
//	std::string::operator=(src);
//	return *this;
//}
//
//inline ValueType<std::string>& ValueType<std::string>::operator=(
//		const std::string& src) {
//	std::string::operator=(src);
//	return *this;
//}

inline ValueType<std::string>& ValueType<std::string>::operator=(
		const ValueType<std::string>& src) {
	std::string::operator=(src);
	return *this;
}

inline ValueType<std::string>& ValueType<std::string>::operator+=(
		char* const src) {
	std::string::operator+=(src);
	return *this;
}

}

}
