/*
 * Transition.h
 *
 *  Created on: 13.03.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_TRANSITION_INCLUDED
#define ODEMX_SIMML_TRANSITION_INCLUDED

#include <odemx/simml/Block.h>
#include <odemx/simml/ContextWaitCondition.h>
#include <odemx/simml/StateMachine.h>

namespace odemx {

namespace simml {

class StateMachine;
typedef void (StateMachine::*State)();

class Transition {
public:
	typedef long ParameterType;
	class Parameter: public std::vector<ParameterType> {
	public:
		Parameter(ParameterType state, ParameterType transition,
				ParameterType constraint);
	};
	typedef synchronization::IMemory Trigger;

	// create Transition waiting for a time event
	Transition(base::Simulation& sim, const data::Label& label,
			bool isRelative, base::SimTime time, Parameter* parameter,
			State target);
	// create Transition waiting for a state event
	Transition(base::Simulation& sim, const data::Label& label, Block* context,
			std::vector<synchronization::Monitor*>* monitors, Parameter* parameter,
			State target);
	// create Transition waiting for a completion event
	Transition(base::Simulation& sim, const data::Label& label,
			Parameter* parameter, State target);
	virtual ~Transition();

	Trigger* getTrigger();
	Parameter* getParameter();
	State getTarget();

private:
	Trigger* trigger;
	Parameter* parameter;
	State target;
};

}

}

#endif /* ODEMX_SIMML_TRANSITION_INCLUDED */
