/*
 * StateMachine.h
 *
 *  Created on: 13.01.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_STATEMACHINE_INCLUDED
#define ODEMX_SIMML_STATEMACHINE_INCLUDED

#include <odemx/simml/Behavior.h>
#include <odemx/simml/Transition.h>
#include <vector>

namespace odemx {

namespace simml {

class Transition;

class StateMachine: public Behavior {
public:
	typedef void (StateMachine::*State)();
	enum PseudoState {
		NONE, CHOICE
	};
	template<typename T> struct Function {
		typedef void (T::*FunctionPointer)();
		static State Pointer(FunctionPointer functionPointer) {
			return reinterpret_cast<State> (functionPointer);
		}
	};
	typedef bool
	(Block::*ContextConstraint)(base::SimTime time,
			const std::vector<long>* cases) const;
	typedef void (Block::*ContextBehavior)(base::SimTime time,
			const std::vector<long>* cases);
	typedef std::vector<Transition*> TransitionVector;

	static State terminate;
	static ContextConstraint contextConstraint;
	static ContextBehavior contextBehavior;

	StateMachine(Block* context, base::Simulation& sim,
			const data::Label& label, base::ProcessObserver* obs = 0);
	virtual ~StateMachine();
	virtual void initial() = 0;
	int main();
	State getState();
	PseudoState getPseudoState();
	TransitionVector& getPossibleTransitions();

protected:
	void setPseudoState(PseudoState pseudoState);
	void addPossibleTransition(Transition* transition);

private:
	typedef synchronization::IMemoryVector TriggerVector;

	State state;
	PseudoState pseudoState;
	TransitionVector possibleTransitions;

	void setState(State state);
	void deletePossibleTransitions();
	static void deleteTransition(Transition* transition);
	Transition* fireTransition();
	Transition* compareTrigger(const TransitionVector& transitions,
			bool receiveTrigger, TriggerVector& triggers,
			TransitionVector& triggeredTransitions);
	Transition* checkGuards(const TransitionVector& transitions) const;
};

}

}

#endif /* ODEMX_SIMML_STATEMACHINE_INCLUDED */
