/*
 * PropertyT.h
 *
 *  Created on: 19.07.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_PROPERTYT_INCLUDED
#define ODEMX_SIMML_PROPERTYT_INCLUDED

#include <odemx/simml/monitored_ptr.h>
#include <odemx/simml/ValueType.h>

namespace odemx {

namespace simml {

template<typename T, const bool isComposite = true> class Property;

template<typename T> class PropertyBase: public synchronization::monitored_ptr<T> {
public:
	PropertyBase();
	explicit PropertyBase(T* const src);
	virtual ~PropertyBase();

	PropertyBase<T>& operator=(const PropertyBase<T>& src);
	PropertyBase<T>& operator=(T* const src);
	operator T*() const;
};

template<typename T> class Property<T, true> : public PropertyBase<T> {
public:
	Property();
	explicit Property(T* const src);
	virtual ~Property();

	Property<T, true>& operator=(const Property<T, true>& src);
	Property<T, true>& operator=(const Property<T, false>& src);
	Property<T, true>& operator=(T* const src);

private:
	Property<T, true>& assign(T* const src);
};

template<typename T> class Property<T, false> : public PropertyBase<T> {
public:
	Property();
	explicit Property(T* const src);
	virtual ~Property();

	Property<T, false>& operator=(const Property<T, true>& src);
	Property<T, false>& operator=(const Property<T, false>& src);
	Property<T, false>& operator=(T* const src);

private:
	Property<T, false>& assign(T* const src);
};

template<typename T> class Property<ValueType<T> > : public synchronization::monitored_ptr<
		ValueType<T> > {
public:
	Property();
	Property(const T& src);
	virtual ~Property();

	Property<ValueType<T> >& operator=(const T& src);
	Property<ValueType<T> >& operator=(const Property<ValueType<T> >& src);
	operator T() const;
};

template<> class Property<String> : public synchronization::monitored_ptr<String> {
public:
	Property();
	Property(const String& src);
	Property(const char* chr);
	virtual ~Property();

	Property<String>& operator=(const String& src);
	Property<String>& operator=(const Property<String>& src);
	Property<String>& operator=(const char* src);
	operator const char*() const;
};

}

}

#endif /* ODEMX_SIMML_PROPERTYT_INCLUDED */
