/*
 * PropertyT.cpp
 *
 *  Created on: 27.07.2011
 *      Author: hausding
 */

#include <odemx/simml/PropertyT.h>
#include <odemx/simml/Block.h>

namespace odemx {

namespace simml {

class Block;

template<typename T> PropertyBase<T>::PropertyBase() :
	synchronization::monitored_ptr<T>() {
}

template<typename T> PropertyBase<T>::PropertyBase(T* const src) :
	synchronization::monitored_ptr<T>(src) {
}

template<typename T> PropertyBase<T>::~PropertyBase() {
}

template<typename T> PropertyBase<T>& PropertyBase<T>::operator=(
		const PropertyBase<T>& src) {
	synchronization::monitored_ptr<T>::operator=(src);
	return *this;
}

template<typename T> PropertyBase<T>& PropertyBase<T>::operator=(T* const src) {
	synchronization::monitored_ptr<T>::operator=(src);
	return *this;
}

template<typename T> PropertyBase<T>::operator T*() const {
	return synchronization::monitored_ptr<T>::ptr;
}

template<typename T> Property<T, true>::Property() :
	PropertyBase<T> () {
}

template<typename T> Property<T, true>::Property(T* const src) :
	PropertyBase<T> (src) {
	if (*this)
		(*this)->setOwner((Block**) &this->ptr);
}

template<typename T> Property<T, true>::~Property() {
	delete synchronization::monitored_ptr<T>::ptr;
	synchronization::monitored_ptr<T>::ptr = NULL;
}

template<typename T> Property<T, true>& Property<T, true>::operator=(
		const Property<T, true>& src) {
	return assign(src);
}

template<typename T> Property<T, true>& Property<T, true>::operator=(
		const Property<T, false>& src) {
	return assign(src);
}

template<typename T> Property<T, true>& Property<T, true>::operator=(
		T* const src) {
	return assign(src);
}

template<typename T> Property<T, true>& Property<T, true>::assign(T* const src) {
	if (*this)
		(*this)->setOwner(NULL);
	PropertyBase<T>::operator=(src);
	if (*this)
		(*this)->setOwner((Block**) &this->ptr);
	return *this;
}

template<typename T> Property<T, false>::Property() :
	PropertyBase<T> () {
}

template<typename T> Property<T, false>::Property(T* const src) :
	PropertyBase<T> (src) {
	if (*this)
		(*this)->addReferencer((Block**) &this->ptr);
}

template<typename T> Property<T, false>::~Property() {
}

template<typename T> Property<T, false>& Property<T, false>::operator=(
		const Property<T, true>& src) {
	return assign(src);
}

template<typename T> Property<T, false>& Property<T, false>::operator=(
		const Property<T, false>& src) {
	return assign(src);
}

template<typename T> Property<T, false>& Property<T, false>::operator=(
		T* const src) {
	return assign(src);
}

template<typename T> Property<T, false>& Property<T, false>::assign(
		T* const src) {
	if (*this)
		(*this)->removeReferencer((Block**) &this->ptr);
	PropertyBase<T>::operator=(src);
	if (*this)
		(*this)->addReferencer((Block**) &this->ptr);
	return *this;
}

template<typename T> Property<ValueType<T> >::Property() :
	synchronization::monitored_ptr<ValueType<T> >(new ValueType<T> ()) {
}

template<typename T> Property<ValueType<T> >::Property(const T& src) :
	synchronization::monitored_ptr<ValueType<T> >(new ValueType<T> (src)) {
}

template<typename T> Property<ValueType<T> >::~Property() {
	delete synchronization::monitored_ptr<ValueType<T> >::ptr;
	synchronization::monitored_ptr<ValueType<T> >::ptr = NULL;
}

template<typename T> Property<ValueType<T> >& Property<ValueType<T> >::operator=(
		const T& src) {
	synchronization::monitored_ptr<ValueType<T> >::operator=(src);
	return *this;
}

template<typename T> Property<ValueType<T> >& Property<ValueType<T> >::operator=(
		const Property<ValueType<T> >& src) {
	synchronization::monitored_ptr<ValueType<T> >::operator=(*src);
	return *this;
}

template<typename T> Property<ValueType<T> >::operator T() const {
	return *synchronization::monitored_ptr<ValueType<T> >::ptr;
}

inline Property<String>::Property() :
	synchronization::monitored_ptr<String>(new String()) {
}

inline Property<String>::Property(const String& src) :
	synchronization::monitored_ptr<String>(new String(src)) {
}

inline Property<String>::Property(const char* chr) :
	synchronization::monitored_ptr<String>(new String(chr)) {
}

inline Property<String>::~Property() {
	delete synchronization::monitored_ptr<String>::ptr;
	synchronization::monitored_ptr<String>::ptr = NULL;
}

inline Property<String>& Property<String>::operator=(const String& src) {
	synchronization::monitored_ptr<String>::operator=(src);
	return *this;
}

inline Property<String>& Property<String>::operator=(
		const Property<String>& src) {
	synchronization::monitored_ptr<String>::operator=(*src);
	return *this;
}

inline Property<String>& Property<String>::operator=(const char* src) {
	synchronization::monitored_ptr<String>::operator=(src);
	return *this;
}

inline Property<String>::operator const char*() const {
	return (*synchronization::monitored_ptr<String>::ptr).c_str();
}

}

}
