/*
 * MultiplicityElementT.h
 *
 *  Created on: 16.08.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_MULTIPLICITYELEMENTT_INCLUDED
#define ODEMX_SIMML_MULTIPLICITYELEMENTT_INCLUDED

namespace odemx {

namespace simml {

template<typename Container, const bool isComposite = true> class MultiplicityElement: public Container,
		public synchronization::Monitored<Container> {
public:
	typedef typename Container::value_type value_type;
	MultiplicityElement(int lowerBound = -1, int upperBound = -1);
	virtual ~MultiplicityElement();

	void push_back(const value_type& x);

private:
	int lowerBound;
	int upperBound;
};

}

}

#endif /* ODEMX_SIMML_MULTIPLICITYELEMENTT_INCLUDED */
