/*
 * MultiplicityElementT.cpp
 *
 *  Created on: 16.08.2011
 *      Author: hausding
 */

#include <odemx/simml/MultiplicityElementT.h>

namespace odemx {

namespace simml {

template<typename Container, const bool isComposite> MultiplicityElement<
		Container, isComposite>::MultiplicityElement(int lowerBound,
		int upperBound) :
	Container(), synchronization::Monitored<Container>(), lowerBound(lowerBound),
			upperBound(upperBound) {
	if (upperBound >= 0)
		Container::reserve(upperBound);
}

template<typename Container, const bool isComposite> MultiplicityElement<
		Container, isComposite>::~MultiplicityElement() {
	// TODO Auto-generated destructor stub
}

template<typename Container, const bool isComposite> void MultiplicityElement<
		Container, isComposite>::push_back(const value_type& x) {
	int size = Container::size();
	if (upperBound < 0 || size < upperBound) {
		Container::push_back(x);
		synchronization::Monitored<Container>::getMonitor().checkWaitConditions();
	}
}

}

}
