/*
 * ContextWaitConditionT.h
 *
 *  Created on: 22.03.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_CONTEXTWAITCONDITIONT_INCLUDED
#define ODEMX_SIMML_CONTEXTWAITCONDITIONT_INCLUDED

#include <odemx/simml/WaitCondition.h>

namespace odemx {

namespace synchronization {

template<typename T, typename A> class ContextWaitCondition: public WaitCondition {
public:
	typedef bool
			(T::*Condition)(base::SimTime time, const A* contextArguments) const;
	ContextWaitCondition(T* context, Condition contextCondition,
			base::Simulation& sim, const data::Label& label,
			std::vector<Monitor*>* monitors, A* contextArguments,
			MemoryObserver* obs = 0);
	virtual ~ContextWaitCondition();
	virtual bool condition(base::SimTime time);
	T* getContext();
	Condition getContextCondition();
	A* getContextArguments();

private:
	T* context;
	Condition contextCondition;
	A* contextArguments;
};

}

}

#endif /* ODEMX_SIMML_CONTEXTWAITCONDITIONT_INCLUDED */
