/*
 * ContextWaitConditionT.cpp
 *
 *  Created on: 22.03.2011
 *      Author: hausding
 */

#include <odemx/simml/ContextWaitConditionT.h>

namespace odemx {

namespace synchronization {

template<typename T, typename A> ContextWaitCondition<T, A>::ContextWaitCondition(
		T* context, Condition contextCondition, base::Simulation& sim,
		const data::Label& label, std::vector<Monitor*>* monitors,
		A* contextArguments, MemoryObserver* obs) :
	WaitCondition(sim, label, monitors, obs), context(context),
			contextCondition(contextCondition),
			contextArguments(contextArguments) {
}

template<typename T, typename A> ContextWaitCondition<T, A>::~ContextWaitCondition() {
	// TODO Auto-generated destructor stub
}

template<typename T, typename A> bool ContextWaitCondition<T, A>::condition(
		base::SimTime time) {
	assert(getContext());
	assert(getContextCondition());
	assert(getContextArguments());
	return (getContext()->*getContextCondition())(time, getContextArguments());
}

template<typename T, typename A> T* ContextWaitCondition<T, A>::getContext() {
	return context;
}

template<typename T, typename A> typename ContextWaitCondition<T, A>::Condition ContextWaitCondition<
		T, A>::getContextCondition() {
	return contextCondition;
}

template<typename T, typename A> A* ContextWaitCondition<T, A>::getContextArguments() {
	return contextArguments;
}

}

}
