/*
 * Block.h
 *
 *  Created on: 09.11.2010
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_BLOCK_INCLUDED
#define ODEMX_SIMML_BLOCK_INCLUDED

#include <odemx/simml/Behavior.h>

namespace odemx {

namespace simml {

class Behavior;

class Block {
public:
	Block();
	Block(Behavior* classifierBehavior);
	virtual ~Block();
	Behavior* getClassifierBehavior();
	virtual void _run(base::SimTime time, const std::vector<long>* cases);
	virtual bool
	_check(base::SimTime time, const std::vector<long>* cases) const;
	void exitSimulation();

	Block** getOwner();
	void setOwner(Block** const owner);
	static void setAssociationNULL(Block** const association);
	static void setAssociation(Block** const association, Block* const value);
	void addReferencer(Block** const referencer);
	void removeReferencer(Block** const referencer);

private:
	Behavior* classifierBehavior;
	std::list<Block**> referencers;
	Block** owner;
};

}

}

#endif /* ODEMX_SIMML_BLOCK_INCLUDED */
