/*
 * Behavior.h
 *
 *  Created on: 07.02.2011
 *      Author: hausding
 */

#ifndef ODEMX_SIMML_BEHAVIOR_INCLUDED
#define ODEMX_SIMML_BEHAVIOR_INCLUDED

#include <odemx/base/Process.h>
#include <odemx/base/Simulation.h>
#include <odemx/simml/Block.h>

namespace odemx {

namespace simml {

class Block;

class Behavior: public base::Process {
public:
	virtual ~Behavior();
	Block* getContext() const;
	void setContext(Block* context);

protected:
	Behavior(Block* context, base::Simulation& sim, const data::Label& label,
			base::ProcessObserver* obs);
	virtual int main() = 0;

private:
	Block* context;
};

}

}

#endif /* ODEMX_SIMML_BEHAVIOR_INCLUDED */
