//
// WebWidgetsTest.cpp
//
// $Id: //poco/Main/WebWidgets/testsuite/src/WebWidgetsTest.cpp#6 $
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "WebWidgetsTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/WebWidgets/GridLayout.h"
#include "Poco/WebWidgets/Label.h"


using namespace Poco::WebWidgets;


WebWidgetsTest::WebWidgetsTest(const std::string& name): CppUnit::TestCase(name)
{
}


WebWidgetsTest::~WebWidgetsTest()
{
}


void WebWidgetsTest::testGridLayout()
{
	GridLayout::Ptr ptr = new GridLayout(3);
	assert (ptr->size() == 0);
	ptr->add(new Label("t")); //0.0
	assert (!ptr->get(0,0).isNull());
	assert (!ptr->get(0,0)->parent().isNull());
	assert (ptr->size() == 3);
	ptr->set(new Label("s"),1,0); //1,0
	assert (ptr->size() == 6);
	ptr->add(new Label("u")); // 1,1
	assert (ptr->size() == 6);
	ptr->add(new Label("v")); // 1,2
	assert (ptr->size() == 6);
	ptr->add(new Label("w")); // 2,0
}


void WebWidgetsTest::testGridLayout2()
{
	GridLayout::Ptr ptr = new GridLayout(3,2);
	assert (ptr->size() == 6);
	ptr->add(new Label("t")); //0.0
	assert (!ptr->get(0,0).isNull());
	assert (!ptr->get(0,0)->parent().isNull());
	assert (ptr->size() == 6);
	ptr->set(new Label("s"),1,0); //1,0
	assert (ptr->size() == 6);
	ptr->add(new Label("u")); // 1,1
	assert (ptr->size() == 6);
	ptr->add(new Label("v")); // 1,2
	assert (ptr->size() == 6);
	try
	{
		ptr->add(new Label("w")); // 2,0
		fail("must fail");
	}
	catch(Poco::Exception&)
	{
	}
}


void WebWidgetsTest::setUp()
{
}


void WebWidgetsTest::tearDown()
{
}


CppUnit::Test* WebWidgetsTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("WebWidgetsTest");

	CppUnit_addTest(pSuite, WebWidgetsTest, testGridLayout);
	CppUnit_addTest(pSuite, WebWidgetsTest, testGridLayout2);

	return pSuite;
}
