//
// View.cpp
//
// $Id: //poco/Main/WebWidgets/src/View.cpp#4 $
//
// Library: WebWidgets
// Package: Core
// Module:  View
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/View.h"


namespace Poco {
namespace WebWidgets {


View::View(const std::string& name, const std::type_info& type):
	Renderable(type),
	_name(name),
	_pParent(0),
	_visible(true),
	_showBorder(true),
	_width(0),
	_height(0)
{
}


View::View(const std::type_info& type):
	Renderable(type),
	_name(),
	_pParent(0),
	_visible(true),
	_showBorder(true),
	_width(0),
	_height(0)
{
}

	
View::~View()
{
}


void View::setName(const std::string& name)
{
	_name = name;
}


std::string View::path() const
{
	std::string path;
	if (_pParent)
	{
		path = _pParent->path() + "/";
		path += _name;
	}
	else path = "/";
	return path;
}


View::Ptr View::find(const std::string& path) const
{
	std::string::const_iterator it(path.begin());
	std::string::const_iterator end(path.end());
	if (it != end)
	{
		if (*it == '/')
		{
			++it;
			return root()->find(std::string(it, end));
		}
		else
		{
			std::string childName;
			while (it != end && *it != '/') childName += *it++;
			if (it != end) ++it;
			View::Ptr pChild = findChild(childName);
			if (pChild)
			{
				return pChild->find(std::string(it, end));
			}
			else return pChild;
		}
	}
	else return View::Ptr(const_cast<View*>(this), true);
}

	
View::Ptr View::findChild(const std::string& name) const
{
	return View::Ptr();
}


View::Ptr View::root() const
{
	const View* pRoot = this;
	while (pRoot->_pParent)
		pRoot = pRoot->_pParent;
	return View::Ptr(const_cast<View*>(pRoot), true);
}


void View::show(bool visible)
{
	if (_visible != visible)
	{
		_visible = visible;
		if (_visible)
			onShow();
		else
			onHide();
	}
}


void View::setText(const std::string& text)
{
}


std::string View::getText() const
{
	return std::string();
}


void View::setToolTip(const std::string& text)
{
}


std::string View::getToolTip() const
{
	return std::string();
}


void View::onShow()
{
}


void View::onHide()
{
}


View::Pos::Pos():
	posX(-1),
	posY(-1)
{
}

			
View::Pos::Pos(int x, int y):
	posX(x),
	posY(y)
{
}


} } // namespace Poco::WebWidgets
