//
// ToggleButton.cpp
//
// $Id: //poco/Main/WebWidgets/src/ToggleButton.cpp#6 $
//
// Library: WebWidgets
// Package: Controls
// Module:  ToggleButton
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ToggleButton.h"
#include "Poco/WebWidgets/ToggleButtonCell.h"


#define WWTB_DEFAULT_LABEL ""
#define WWTB_DEFAULT_CHECKED false


namespace Poco {
namespace WebWidgets {



ToggleButton::ToggleButton(const std::string& name, const std::string& label, bool isChecked, const std::type_info& type, Cell::Ptr ptrCell):
	Control(name, type)
{
	init(ptrCell, label, isChecked);
}


ToggleButton::ToggleButton(const std::type_info& type, Cell::Ptr ptrCell):
	Control(type)
{
	init(ptrCell, WWTB_DEFAULT_LABEL, WWTB_DEFAULT_CHECKED);
}


ToggleButton::ToggleButton(const std::string& name, const std::string& label, bool isChecked, const std::type_info& type):
	Control(name, type)
{
	init(label, isChecked);
}


ToggleButton::ToggleButton(const std::type_info& type):
	Control(type)
{
	init(WWTB_DEFAULT_LABEL, WWTB_DEFAULT_CHECKED);
}


ToggleButton::ToggleButton(const std::string& name, const std::string& label, bool isChecked):
	Control(name, typeid(ToggleButton))
{
	init(label, isChecked);
}


ToggleButton::ToggleButton():
	Control(typeid(ToggleButton))
{
	init(WWTB_DEFAULT_LABEL, WWTB_DEFAULT_CHECKED);
}

	
ToggleButton::~ToggleButton()
{
}


void ToggleButton::init(const std::string& label, bool isChecked)
{
	ToggleButtonCell* pCell = new ToggleButtonCell(this, label, isChecked);
	pCell->checked = delegate(*this, &ToggleButton::fireChecked);
	setCell(pCell);
}


void ToggleButton::init(Cell::Ptr ptrCell, const std::string& label, bool isChecked)
{
	ToggleButtonCell::Ptr ptr = ptrCell.cast<ToggleButtonCell>();
	poco_check_ptr (ptr);
	setCell(ptrCell);
	ptr->setChecked(isChecked);
	ptr->setLabel(label);
	ptr->checked = delegate(*this, &ToggleButton::fireChecked);
}


void ToggleButton::setChecked(bool checked)
{
	cell<ToggleButtonCell>()->setChecked(checked);
}


bool ToggleButton::isChecked() const
{
	return cell<ToggleButtonCell>()->isChecked();
}

void ToggleButton::setLabel(const std::string& lbl)
{
	cell<ToggleButtonCell>()->setLabel(lbl);
}


const std::string& ToggleButton::getLabel() const
{
	return cell<ToggleButtonCell>()->getLabel();
}



void ToggleButton::fireChecked(void* pSender)
{
	ToggleButtonEvent changedEvent(this);
	checked(this, changedEvent);
}

} } // namespace Poco::WebWidgets
