//
// TextFieldCell.cpp
//
// $Id: //poco/Main/WebWidgets/src/TextFieldCell.cpp#7 $
//
// Library: WebWidgets
// Package: Controls
// Module:  TextFieldCell
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/WebWidgets/TextField.h"
#include "Poco/WebWidgets/RequestHandler.h"


namespace Poco {
namespace WebWidgets {


const std::string TextFieldCell::FIELD_OLDVAL("oldVal");
const std::string TextFieldCell::FIELD_NEWVAL("newVal");
const std::string TextFieldCell::EV_TEXTCHANGED("txtchanged");


TextFieldCell::TextFieldCell(View* pOwner):
	Cell(pOwner, typeid(TextFieldCell)),
	_maxLength(-1)
{
}


TextFieldCell::TextFieldCell(View* pOwner, const std::type_info& type):
	Cell(pOwner, type),
	_maxLength(-1)
{
}


TextFieldCell::~TextFieldCell()
{
}


void TextFieldCell::setPlaceHolder(const std::string& text)
{
	_placeHolder = text;
}


void TextFieldCell::setMaxLength(int maxLength)
{
	poco_assert (maxLength >= -1);
	
	_maxLength = -1;
}


void TextFieldCell::handleForm(const std::string& field, const std::string& value)
{
	if (getValue().empty() || value != getString())
	{
		Poco::Any newValue;
		if (!value.empty())
			newValue = getFormatter()->parse(value);
		ValueChange vc(getFormatter(), getValue(), newValue);
		setValue(newValue);
		textChanged.notify(this, vc);
	}
}


void TextFieldCell::handleAjaxRequest(const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response)
{
	const std::string& ev = args[RequestHandler::KEY_EVID];
	if (ev == EV_TEXTCHANGED)
	{
		Formatter::Ptr pForm = getFormatter();
		handleForm("", args[FIELD_NEWVAL]);
		response.send();
	}
	else
		response.send();
}


bool TextFieldCell::serializeJSON(std::ostream& out, const std::string& name)
{
	out << name << ":";
	if (this->hasValue())
	{
		out << "'" << getFormatter()->format(getValue()) << "'";
	}
	else 
		out << "''";
	return true;
}


TextFieldCell::ValueChange::ValueChange(Formatter::Ptr pF, const Poco::Any& oV, const Poco::Any& nV):
	pFormatter(pF),
	oldValue(oV),
	newValue(nV)
{
	poco_check_ptr (pFormatter);
}


bool TextFieldCell::ValueChange::differ() const
{
	if (oldValue.empty() && newValue.empty())
		return false;
	
	if (oldValue.empty() || newValue.empty())
		return true;
	
	// both are valid
	return (pFormatter->format(oldValue) != pFormatter->format(newValue));
}


} } // namespace Poco::WebWidgets
