//
// TextEdit.cpp
//
// $Id: //poco/Main/WebWidgets/src/TextEdit.cpp#2 $
//
// Library: WebWidgets
// Package: Controls
// Module:  TextEdit
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/TextEdit.h"
#include "Poco/WebWidgets/TextEditCell.h"


namespace Poco {
namespace WebWidgets {


TextEdit::TextEdit(const std::string& name, const std::type_info& type, Cell::Ptr ptrCell):
	Control(name, type)
{
	init(ptrCell);
}


TextEdit::TextEdit(const std::type_info& type, Cell::Ptr ptrCell):
	Control(type)
{
	init(ptrCell);
}


TextEdit::TextEdit(const std::string& name, const std::type_info& type):
	Control(name, type)
{
	init();
}


TextEdit::TextEdit(const std::type_info& type):
	Control(type)
{
	init();
}


TextEdit::TextEdit(const std::string& name):
	Control(name, typeid(TextEdit))
{
	init();
}
	
	
TextEdit::TextEdit():
	Control(typeid(TextEdit))
{
	init();
}

	
TextEdit::~TextEdit()
{
}


void TextEdit::setPlaceHolder(const std::string& text)
{
	cell<TextEditCell>()->setPlaceHolder(text);
}

	
const std::string& TextEdit::getPlaceHolder() const
{
	return cell<TextEditCell>()->getPlaceHolder();
}


void TextEdit::setHeightInPixel(int height)
{
	cell<TextEditCell>()->setHeightInPixel(height);
}


int TextEdit::getHeightInPixel() const
{
	return cell<TextEditCell>()->getHeightInPixel();
}


void TextEdit::setGrow(bool grow)
{
	cell<TextEditCell>()->setGrow(grow);
}


bool TextEdit::getGrow() const
{
	return cell<TextEditCell>()->getGrow();
}


void TextEdit::init()
{
	TextEditCell* pCell = new TextEditCell(this);
	pCell->textChanged = delegate(*this, &TextEdit::fireTextChanged);
	setCell(pCell);
}


void TextEdit::init(Cell::Ptr ptrCell)
{
	TextEditCell::Ptr ptr = ptrCell.cast<TextEditCell>();
	poco_check_ptr (ptr);

	ptr->textChanged = delegate(*this, &TextEdit::fireTextChanged);
	setCell(ptrCell);
}


void TextEdit::fireTextChanged(void* pSender)
{
	TextEditEvent changedEvent(this);
	textChanged(this, changedEvent);
}


} } // namespace Poco::WebWidgets
