//
// Renderable.cpp
//
// $Id: //poco/Main/WebWidgets/src/Renderable.cpp#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  Renderable
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/Renderable.h"
#include "Poco/WebWidgets/RenderContext.h"
#include "Poco/WebWidgets/LookAndFeel.h"


namespace Poco {
namespace WebWidgets {


Poco::FastMutex Renderable::_nextIdMutex;
Renderable::ID Renderable::_nextId(0);


Renderable::Renderable(const std::type_info& type):
	_type(type),
	_pLookAndFeel(0),
	_pRenderer(0)
{
	Poco::FastMutex::ScopedLock lock(_nextIdMutex);
	_id = _nextId++;
}


Renderable::~Renderable()
{
}


Renderer& Renderable::renderer(const LookAndFeel& lookAndFeel) const
{
	if (_pLookAndFeel != &lookAndFeel)
	{
		_pRenderer    = lookAndFeel.rendererFor(_type);
		_pLookAndFeel = &lookAndFeel;
	}
	return *_pRenderer;
}


void Renderable::renderHead(const RenderContext& context, std::ostream& str) const
{
	renderer(context.lookAndFeel()).renderHead(this, context, str);
}


void Renderable::renderBody(const RenderContext& context, std::ostream& str) const
{
	renderer(context.lookAndFeel()).renderBody(this, context, str);
}


} } // namespace Poco::WebWidgets
