//
// Frame.cpp
//
// $Id: //poco/Main/WebWidgets/src/Frame.cpp#2 $
//
// Library: WebWidgets
// Package: Views
// Module:  Frame
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/Frame.h"


namespace Poco {
namespace WebWidgets {


Frame::Frame():
	View(typeid(Frame)),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
}


Frame::Frame(const std::string& name):
	View(name, typeid(Frame)),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
}


Frame::Frame(const std::string& name, const std::string& title):
	View(name, typeid(Frame)),
	_pChild(),
	_title(title),
	_collapsible(false),
	_collapsed(false)
{
}


Frame::Frame(View::Ptr pChild):
	View(typeid(Frame)),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
	setChild(pChild);
}


Frame::Frame(const std::string& name, View::Ptr pChild):
	View(name, typeid(Frame)),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
	setChild(pChild);
}


Frame::Frame(const std::string& name, const std::string& title, View::Ptr pChild):
	View(name, typeid(Frame)),
	_pChild(),
	_title(title),
	_collapsible(false),
	_collapsed(false)
{
	setChild(pChild);
}


Frame::Frame(const std::type_info& type):
	View(type),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
}


Frame::Frame(const std::string& name, const std::type_info& type):
	View(name, type),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
}


Frame::Frame(View::Ptr pChild, const std::type_info& type):
	View(type),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
	setChild(pChild);
}


Frame::Frame(const std::string& name, View::Ptr pChild, const std::type_info& type):
	View(name, typeid(Frame)),
	_pChild(),
	_title(),
	_collapsible(false),
	_collapsed(false)
{
	setChild(pChild);
}


Frame::~Frame()
{
}


void Frame::setChild(View::Ptr pChild)
{
	if (_pChild)
		rejectChild(_pChild);
	if (pChild)
		adoptChild(pChild);
	_pChild = pChild;
}


View::Ptr Frame::findChild(const std::string& name) const
{
	if (_pChild && name == _pChild->getName())
		return _pChild;

	return View::Ptr();
}


} } // namespace Poco::WebWidgets
