//
// ComboBoxCell.cpp
//
// $Id: //poco/Main/WebWidgets/src/ComboBoxCell.cpp#2 $
//
// Library: WebWidgets
// Package: Controls
// Module:  ComboBoxCell
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ComboBoxCell.h"
#include "Poco/WebWidgets/RequestHandler.h"
#include "Poco/DateTime.h"


namespace Poco {
namespace WebWidgets {


const std::string ComboBoxCell::FIELD_VAL("val");
const std::string ComboBoxCell::EV_LOAD("doLoad");
const std::string ComboBoxCell::EV_AFTERLOAD("afterLoad");
const std::string ComboBoxCell::EV_SELECTED("sel");
const std::string ComboBoxCell::EV_BEFORESELECT("befSel");


ComboBoxCell::ComboBoxCell(View* pOwner):
	TextFieldCell(pOwner, typeid(ComboBoxCell))
{
}


ComboBoxCell::~ComboBoxCell()
{
}


void ComboBoxCell::erase(const Any& elem)
{
	std::vector<Any>::iterator it = begin();
	Formatter::Ptr ptr=getFormatter();
	std::string elemStr(ptr->format(elem));
	while (it != end())
	{
		if (elemStr == ptr->format(*it))
		{
			_elements.erase(it);
			return;
		}
		++it;
	}
}


void ComboBoxCell::handleForm(const std::string& field, const std::string& value)
{
	Formatter::Ptr pForm(getFormatter());
	if (pForm)
	{
		setSelected(pForm->parse(value));
	}
}


void ComboBoxCell::handleAjaxRequest(const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response)
{
	const std::string& ev = args[RequestHandler::KEY_EVID];
	if (ev == EV_LOAD)
	{
		Poco::Net::HTTPServerResponse* pResponse = &response;
		beforeLoad.notify(this, pResponse);
		// response is handled in beofreLoad callback
	}
	else if (ev == EV_SELECTED)
	{
		Formatter::Ptr pForm(getFormatter());
		if (pForm)
		{
			setSelected(pForm->parse(args[FIELD_VAL]));
		}

		response.send();
	}
	else if (ev == EV_BEFORESELECT)
	{
		Formatter::Ptr pForm(getFormatter());
		Poco::Any newVal = pForm->parse(args[FIELD_VAL]);
		beforeSelect(this, newVal);
		response.send();
	}
	else if (ev == EV_AFTERLOAD)
	{
		afterLoad(this);
		response.send();
	}
}


void ComboBoxCell::setSelected(const Any& elem)
{
	//don't throw beforeSelect here: it's a web only event
	//(otherwise we get two beforeSelect events)
	Poco::Any old;
	if (hasSelected())
		old = getSelected();
	OldNewValue aPair = std::make_pair(old, elem);
	setValue(elem);
	selected(this, aPair);
}


bool ComboBoxCell::serializeJSON(std::ostream& out, const std::string& name)
{
	out << name << ":";
	if (hasSelected())
	{
		const Poco::Any& sel = getSelected();
		if (sel.type() == typeid(std::string) || sel.type() == typeid(Poco::DateTime))
			out << "'" << getFormatter()->format(sel) << "'";
		else
			out << getFormatter()->format(sel);
	}
	else 
		out << "''";
	return true;	
}


} } // namespace Poco::WebWidgets
