//
// ComboBox.cpp
//
// $Id: //poco/Main/WebWidgets/src/ComboBox.cpp#5 $
//
// Library: WebWidgets
// Package: Controls
// Module:  ComboBox
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ComboBox.h"
#include "Poco/WebWidgets/ComboBoxCell.h"
#include "Poco/Delegate.h"


namespace Poco {
namespace WebWidgets {


ComboBox::ComboBox(const std::string& name, const std::type_info& type):
	TextField(name, type, new ComboBoxCell(this))
{
	ComboBoxCell::Ptr pCell = cell<ComboBoxCell>();
	pCell->selected += Poco::delegate(this, &ComboBox::fireSelected);
	pCell->beforeSelect += Poco::delegate(this, &ComboBox::fireBeforeSelect);
	pCell->afterLoad = delegate(*this, &ComboBox::fireAfterLoad);
}


ComboBox::ComboBox(const std::type_info& type):
	TextField(type, new ComboBoxCell(this))
{
	ComboBoxCell::Ptr pCell = cell<ComboBoxCell>();
	pCell->selected += Poco::delegate(this, &ComboBox::fireSelected);
	pCell->beforeSelect += Poco::delegate(this, &ComboBox::fireBeforeSelect);
	pCell->afterLoad = delegate(*this, &ComboBox::fireAfterLoad);
}


ComboBox::ComboBox(const std::string& name):
	TextField(name, typeid(ComboBox), new ComboBoxCell(this))
{
	ComboBoxCell::Ptr pCell = cell<ComboBoxCell>();
	pCell->selected += Poco::delegate(this, &ComboBox::fireSelected);
	pCell->beforeSelect += Poco::delegate(this, &ComboBox::fireBeforeSelect);
	pCell->afterLoad = delegate(*this, &ComboBox::fireAfterLoad);
}


ComboBox::ComboBox():
	TextField(typeid(ComboBox), new ComboBoxCell(this))
{
	ComboBoxCell::Ptr pCell = cell<ComboBoxCell>();
	pCell->selected += Poco::delegate(this, &ComboBox::fireSelected);
	pCell->beforeSelect += Poco::delegate(this, &ComboBox::fireBeforeSelect);
	pCell->afterLoad = delegate(*this, &ComboBox::fireAfterLoad);
}


ComboBox::~ComboBox()
{
}


void ComboBox::fireSelected(const void* pSender, const ComboBoxCell::OldNewValue& oldNewPair)
{
	selected(this, oldNewPair);
}


void ComboBox::fireBeforeSelect(const void* pSender, const Poco::Any& newValue)
{
	beforeSelect(this, newValue);
}


void ComboBox::fireAfterLoad(void* pSender)
{
	ComboBoxEvent sel(this);
	afterLoad(this, sel);
}


} } // namespace Poco::WebWidgets
