//
// Color.cpp
//
// $Id: //poco/Main/WebWidgets/src/Color.cpp#3 $
//
// Library: WebWidgets
// Package: Core
// Module:  Color
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/Color.h"
#include "Poco/Format.h"
#include "Poco/NumberParser.h"
#include "Poco/Exception.h"
#include <algorithm>
#include <cstdio>


using Poco::format;
using Poco::NumberParser;


namespace Poco {
namespace WebWidgets {


const Color::Predefined Color::predefined[PREDEFINED_COUNT] = 
{
	{"aqua",    0x00, 0xff, 0xff},
	{"black",   0x00, 0x00, 0x00},
	{"blue",    0x00, 0x00, 0xff},
	{"fuchsia", 0xff, 0x00, 0xff},
	{"green",   0x00, 0x80, 0x00},
	{"grey",    0x80, 0x80, 0x80},
	{"lime",    0x00, 0xff, 0x00},
	{"maroon",  0x80, 0x00, 0x00},
	{"navy",    0x00, 0x00, 0x80},
	{"olive",   0x80, 0x80, 0x00},
	{"purple",  0x80, 0x00, 0x80},
	{"red",     0xff, 0x00, 0x00},
	{"silver",  0xc0, 0xc0, 0xc0},
	{"teal",    0x00, 0x80, 0x80},
	{"white",   0xff, 0xff, 0xff},
	{"yellow",  0xff, 0xff, 0x00}
};


Color::Color():
	_red(0),
	_green(0),
	_blue(0)
{
}


Color::Color(Poco::UInt8 red, Poco::UInt8 green, Poco::UInt8 blue):
	_red(red),
	_green(green),
	_blue(blue)
{
}

	
Color::Color(const std::string& htmlColor)
{
	poco_assert (htmlColor.size() > 0);	
	
	if (htmlColor[0] == '#' && (htmlColor.size() == 4 || htmlColor.size() == 7))
	{
		std::size_t x = htmlColor.size()/3;
		_red   = static_cast<Poco::UInt8>(NumberParser::parse(htmlColor.substr(0, x)));
		_green = static_cast<Poco::UInt8>(NumberParser::parse(htmlColor.substr(1*x, x)));
		_blue  = static_cast<Poco::UInt8>(NumberParser::parse(htmlColor.substr(2*x, x)));		
	}
	else
	{
		for (int i = 0; i < PREDEFINED_COUNT; ++i)
		{
			if (htmlColor == predefined[i].name)
			{
				_red   = predefined[i].red;
				_green = predefined[i].green;
				_blue  = predefined[i].blue;
				break;
			}
		}
		throw Poco::InvalidArgumentException("Invalid color", htmlColor);
	}
}

	
Color::Color(const Color& color):
	_red(color._red),
	_green(color._green),
	_blue(color._blue)
{
}

			
Color::~Color()
{
}

	
void Color::swap(Color& color)
{
	std::swap(_red, color._red);
	std::swap(_green, color._green);
	std::swap(_blue, color._blue);
}

	
Color& Color::operator = (const Color& color)
{
	Color tmp(color);
	swap(tmp);
	return *this;
}

		
std::string Color::asHTML() const
{
	return format("#%02x%02x%02x", int(_red), int(_green), int(_blue));
}


} } // namespace Poco::WebWidgets
