//
// CheckButton.cpp
//
// $Id: //poco/Main/WebWidgets/src/CheckButton.cpp#4 $
//
// Library: WebWidgets
// Package: ToggleButtons
// Module:  CheckButton
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/CheckButton.h"
#include "Poco/WebWidgets/CheckButtonCell.h"


namespace Poco {
namespace WebWidgets {



CheckButton::CheckButton(const std::string& name, const std::string& label, bool isChecked, const std::type_info& type, Cell::Ptr ptrCell):
	ToggleButton(name, label, isChecked, type)
{
	init(ptrCell);
}


CheckButton::CheckButton(const std::type_info& type, Cell::Ptr ptrCell):
	ToggleButton(type)
{
	init(ptrCell);
}


CheckButton::CheckButton(const std::string& name, const std::string& label, bool isChecked, const std::type_info& type):
	ToggleButton(name, label, isChecked, type)
{
	init();
}


CheckButton::CheckButton(const std::type_info& type):
	ToggleButton(type)
{
	init();
}


CheckButton::CheckButton(const std::string& name, const std::string& label, bool isChecked):
	ToggleButton(name, label, isChecked, typeid(CheckButton))
{
	init();
}
	
	
CheckButton::CheckButton():
	ToggleButton(typeid(CheckButton))
{
	init();
}

	
CheckButton::~CheckButton()
{
}


void CheckButton::init()
{
	CheckButtonCell* pCell = new CheckButtonCell(this, getLabel(), isChecked());
	init(pCell);
}


void CheckButton::init(Cell::Ptr ptrCell)
{
	std::string lbl(getLabel());
	bool checked = isChecked();
	ToggleButton::init(ptrCell,lbl, checked);
}


} } // namespace Poco::WebWidgets
