//
// TableUpdater.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/TableUpdater.h#4 $
//
// Library: WebWidgets
// Package: Views
// Module:  TableUpdater
//
// Definition of the TableUpdater class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_TableUpdater_INCLUDED
#define WebWidgets_TableUpdater_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/WebWidgets/TableModel.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include "Poco/Any.h"


namespace Poco {
namespace WebWidgets {
	class Table;


class WebWidgets_API TableUpdater: public Poco::RefCountedObject
	/// TableUpdater defines the interface for data retrieval for a Table
{
public:
	typedef Poco::AutoPtr<TableUpdater> Ptr;

	TableUpdater(TableModel::Ptr pModel);
		/// Creates the TableUpdater for the given table

	virtual void update() = 0;
		/// Updates the table from a given source
		/// Will update the internally stored TableModel

	virtual TableModel::Ptr model();
		/// returns the latest model

	virtual const TableModel::Ptr model() const;
		/// returns the latest model

protected:
	TableUpdater();
		/// Creates the TableUpdater

	virtual ~TableUpdater();
		/// Destroys the TableUpdater.

private:
	TableModel::Ptr _pModel;
};


//
// Inlines
//

inline TableModel::Ptr TableUpdater::model()
{
	return _pModel;
}


inline const TableModel::Ptr TableUpdater::model() const
{
	return _pModel;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_TableUpdater_INCLUDED
