//
// TabView.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/TabView.h#3 $
//
// Library: WebWidgets
// Package: Views
// Module:  TabView
//
// Definition of the TabView class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_TabView_INCLUDED
#define WebWidgets_TabView_INCLUDED


#include "Poco/WebWidgets/ContainerView.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API TabView: public ContainerView
	/// A TabView
{
public:
	typedef Poco::AutoPtr<TabView> Ptr;

	static const ContainerView::ViewVec::size_type NONE_SELECTED;
	
	TabView();
		/// Creates an anonymous TabView.
		
	TabView(const std::string& name);
		/// Creates a TabView with the given name.

	void setActiveView(ContainerView::ViewVec::size_type pos);
		/// Sets the active view, pos must be valid. If pos is NONE_SELECTED no view is active

	ContainerView::ViewVec::size_type getActiveView() const;
		/// Returns the active view. 

protected:
	TabView(const std::string& name, const std::type_info& type);
		/// Creates a TabView and assigns it the given name.
		
	TabView(const std::type_info& type);
		/// Creates a TabView.
		
	~TabView();
		/// Destroys the TabView.

private:
	ContainerView::ViewVec::size_type _activeView;
};


inline ContainerView::ViewVec::size_type TabView::getActiveView() const
{
	return _activeView;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_TabView_INCLUDED
