//
// SubmitButton.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/SubmitButton.h#1 $
//
// Library: WebWidgets
// Package: Controls
// Module:  SubmitButton
//
// Definition of the SubmitButton class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_SubmitButton_INCLUDED
#define WebWidgets_SubmitButton_INCLUDED


#include "Poco/WebWidgets/Button.h"
#include "Poco/FIFOEvent.h"


namespace Poco {
namespace WebWidgets {


class SubmitButtonCell;


class WebWidgets_API SubmitButton: public Button
	/// A plain old Submitbutton.
{
public:
	typedef Poco::AutoPtr<SubmitButton> Ptr;
	
	FIFOEvent<SubmitButton*> afterSubmit; /// thrown whenever all form values are assigned and the submit is done

	SubmitButton();
		/// Creates an anonymous SubmitButton.
		
	SubmitButton(const std::string& name);
		/// Creates a SubmitButton with the given name.
		
	SubmitButton(const std::string& name, const std::string& lblTxt);
		/// Creates a SubmitButton with the given name and label text.

protected:
	SubmitButton(const std::string& name, const std::type_info& type);
		/// Creates a SubmitButton and assigns it the given name.

	SubmitButton(const std::type_info& type);
		/// Creates a SubmitButton.

	SubmitButton(const std::string& name, const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a SubmitButton and assigns it the given name.

	SubmitButton(const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a SubmitButton.

	~SubmitButton();
		/// Destroys the SubmitButton.
};


} } // namespace Poco::WebWidgets


#endif // WebWidgets_SubmitButton_INCLUDED
