//
// SimpleTableModel.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/SimpleTableModel.h#2 $
//
// Library: WebWidgets
// Package: ChangeThis
// Module:  SimpleTableModel
//
// Definition of the SimpleTableModel class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_SimpleTableModel_INCLUDED
#define WebWidgets_SimpleTableModel_INCLUDED


#include "Poco/WebWidgets/TableModel.h"
#include "Poco/Mutex.h"
#include <vector>


namespace Poco {
namespace WebWidgets {


class WebWidgets_API SimpleTableModel: public TableModel
	/// A simple implementation of a tablemodel which reads/writes data to memory
	/// Avoid deleting rows, expensive.
{
public:
	typedef std::vector<Poco::Any> Row;
	typedef std::vector<Row> TableData;
	typedef Poco::AutoPtr<SimpleTableModel> Ptr;

	SimpleTableModel(std::size_t colCnt);
		/// Creates the SimpleTableModel.

	const Poco::Any& getValue(std::size_t row, std::size_t col) const;
		///Returns the value at pos(row, col) or an empty Any if no data is stored there

	std::size_t getRowCount() const;
		/// Returns the total number of rows

	void setValue(const Poco::Any& val, std::size_t row, std::size_t col);
		/// Sets the value at pos(row, col)

	void deleteRow(std::size_t row);
		/// Removes the row from the TableModel. NOT IMPLEMENTED!
		
	void clear();
		/// Deletes all rows from the TableModel	

	TableModel::Ptr clone() const;
		/// Creates a deep-copy of the table
	
protected:
	virtual ~SimpleTableModel();
		/// Destroys the SimpleTableModel.

private:
	TableData _data;
	mutable Poco::FastMutex _mutex;
};


inline const Poco::Any& SimpleTableModel::getValue(std::size_t row, std::size_t col) const
{
	return _data[row][col];
}


inline std::size_t SimpleTableModel::getRowCount() const
{
	return _data.size();
}


inline void SimpleTableModel::setValue(const Poco::Any& val, std::size_t row, std::size_t col)
{
	Poco::FastMutex::ScopedLock lock(_mutex);
	if (_data.size() < row+1)
		_data.resize(row+1, Row(getColumnCount()));
	_data[row][col] = val;
}


inline void SimpleTableModel::deleteRow(std::size_t row)
{
	throw Poco::NotImplementedException("");
}


inline void SimpleTableModel::clear()
{
	_data.clear();
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_SimpleTableModel_INCLUDED
