//
// ResourceManager.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/ResourceManager.h#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  ResourceManager
//
// Definition of the ResourceManager class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_ResourceManager_INCLUDED
#define WebWidgets_ResourceManager_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include <vector>
#include <string>


namespace Poco {

	class Path;
	
namespace WebWidgets {


class WebApplication;


class WebWidgets_API ResourceManager: public Poco::RefCountedObject
	/// The ResourceManager manages JS and CSS includes. Please note that there are two ResourceManagers:
	/// There is a global ResourceManager that provides common includes for all WebPages (like the rendering JS library),
	/// and there is a local ResourceManager on a per WebPage that allows to define additional includes.
	///
	/// TODO: It would be nice if it also provides some sort of automatic
	/// mapping from local files to web uris, i.e you provide the server root dir
	/// and it converts local files automatically to a relative web server path.
	///
	/// - how to handle requests to files inside Zips?
	///
	/// - how to handle requests to files outside the root dir?
	/// (would be nice to have a tool that collects all the referenced files into one bundle and have requests
	/// only into zip, or alternatively: simply copy all the files into one directory, decompress ZIP files
	/// where requested)
{
public:
	typedef std::vector<std::string> Includes;
	typedef Poco::AutoPtr<ResourceManager> Ptr;

	ResourceManager();
		/// Creates the ResourceManager, 

	~ResourceManager();
		/// Destroys the ResourceManager.
	
	void appendJSInclude(const Poco::Path& aPath);
		/// Adds a JS include, no check for duplicates
	
	void appendCSSInclude(const Poco::Path& aPath);
		/// Adds a CSS include, no check for duplicates
	
	const Includes& jsIncludes() const;
		/// Returns all JS includes
	
	const Includes& cssIncludes() const;
		/// Returns all CSS includes
	
private:
	
	Includes _js;
	Includes _css;
};


//
// Inlines
//

inline const ResourceManager::Includes& ResourceManager::jsIncludes() const
{
	return _js;
}

	
inline const ResourceManager::Includes& ResourceManager::cssIncludes() const
{
	return _css;
}

	
} } // namespace Poco::WebWidgets


#endif // WebWidgets_ResourceManager_INCLUDED
