//
// Renderer.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Renderer.h#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  Renderer
//
// Definition of the Renderer class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Renderer_INCLUDED
#define WebWidgets_Renderer_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include <ostream>


namespace Poco {
namespace WebWidgets {


class Renderable;
class RenderContext;


class WebWidgets_API Renderer: public Poco::RefCountedObject
	/// A Renderer is responsible for generating HTML, CSS and JavaScript
	/// code for a specific widget.
	///
	/// Renderer objects are stateless and a Renderer will usually be shared and 
	/// used by more than one Renderable object. 
{
public:
	typedef Poco::AutoPtr<Renderer> Ptr;

	Renderer();
		/// Creates the Renderer object.
		
	virtual void renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr) = 0;
		/// Emits code for the page header to the given output stream.

	virtual void renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr) = 0;
		/// Emits code for the page body to the given output stream.

protected:		
	virtual ~Renderer();
		/// Destroys the Renderer object.

private:
	Renderer(const Renderer&);
	Renderer& operator = (const Renderer&);
};


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Renderer_INCLUDED
