//
// Frame.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Frame.h#3 $
//
// Library: WebWidgets
// Package: Views
// Module:  Frame
//
// Definition of the Frame class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Frame_INCLUDED
#define WebWidgets_Frame_INCLUDED


#include "Poco/WebWidgets/View.h"


namespace Poco {
namespace WebWidgets {



class WebWidgets_API Frame: public View
	/// A Frame functions as a wrapper around another view
{
public:
	typedef Poco::AutoPtr<Frame> Ptr;

	Frame();
		/// Creates an unnamed Frame.

	Frame(const std::string& name);
		/// Creates the Frame.
		
	Frame(const std::string& name, const std::string& title);
		/// Creates the Frame.

	Frame(View::Ptr pChild);
		/// Creates an unnamed Frame.

	Frame(const std::string& name, View::Ptr pChild);
		/// Creates the Frame.
		
	Frame(const std::string& name, const std::string& title, View::Ptr pChild);
		/// Creates the Frame.	

	void setChild(View::Ptr pChild);
		/// Sets the child of the panel

	View::Ptr getChild() const;
		/// Returns the child of the panel

	View::Ptr findChild(const std::string& name) const;

	void setText(const std::string& text);
		/// Sets the title of the Frame

	void setTitle(const std::string& text);
		/// Sets the title of the Frame

	std::string getText() const;
		/// Returns the title of the Frame

	const std::string& getTitle() const;
		/// Returns the title of the Frame
		
	void setCollapsible(bool val);
		/// En/Disable collapsible
	
	bool collapsible() const;
		/// Returns collapsible property
		
	void setCollapsed(bool coll);
		/// How should the Frame be rendered initially?
		
	bool collapsed() const;
		/// Returns how the Frame should be rendered initially

protected:
	Frame(const std::type_info& type);
		/// Creates an unnamed Frame.

	Frame(const std::string& name, const std::type_info& type);
		/// Creates the Frame.

	Frame(View::Ptr pChild, const std::type_info& type);
		/// Creates an unnamed Frame.

	Frame(const std::string& name, View::Ptr pChild, const std::type_info& type);
		/// Creates the Frame.

	~Frame();
		/// Destroys the Frame.

private:
	View::Ptr   _pChild;
	std::string _title;
	bool        _collapsible;
	bool        _collapsed;
};


//
// inlines
//

inline View::Ptr Frame::getChild() const
{
	return _pChild;
}


inline void Frame::setText(const std::string& text)
{
	setTitle(text);
}


inline void Frame::setTitle(const std::string& text)
{
	_title = text;
}


inline std::string Frame::getText() const
{
	return getTitle();
}


inline const std::string& Frame::getTitle() const
{
	return _title;
}


inline void Frame::setCollapsible(bool val)
{
	_collapsible = val;
}

	
inline bool Frame::collapsible() const
{
	return _collapsible;
}


inline void Frame::setCollapsed(bool coll)
{
	_collapsed = coll;
}

		
inline bool Frame::collapsed() const
{
	return _collapsed;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Frame_INCLUDED
