//
// Form.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Form.h#6 $
//
// Library: WebWidgets
// Package: Views
// Module:  Form
//
// Definition of the Form class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-execuForm object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Form_INCLUDED
#define WebWidgets_Form_INCLUDED


#include "Poco/WebWidgets/ContainerView.h"
#include "Poco/WebWidgets/RequestProcessor.h"
#include "Poco/URI.h"
#include "Poco/FIFOEvent.h"
#include <map>


namespace Poco {
	namespace Net {
		class HTMLForm;
	}
namespace WebWidgets {


class WebWidgets_API Form: public ContainerView, public RequestProcessor
	/// A Form represents a HTML form.
{
public:
	typedef Poco::AutoPtr<Form> Ptr;
	
	static const std::string FORM_ID; /// form name to 
	static const std::string EV_RELOAD; /// event name for reloading the form
	static const std::string METHOD_GET;
	static const std::string METHOD_POST;
	
	static const std::string ENCODING_URL;       /// "application/x-www-form-urlencoded"
	static const std::string ENCODING_MULTIPART; /// "multipart/form-data"
	
	Poco::FIFOEvent<Form*> beforeReload; /// triggered before a Form is reloaded so that you can update form fields with recent values
	
	Form(const Poco::URI& uri);
		/// Creates an anonymous Form.

	Form(const std::string& name, const Poco::URI& uri);
		/// Creates a Form with the given name.
		
	void setMethod(const std::string& method);
		/// Sets the HTTP request method for submitting the form.
		
	const std::string& getMethod() const;
		/// Returns the HTTP request method for submitting the form.
		
	void setEncoding(const std::string& encoding);
		/// Sets the encoding used to encode the form in the HTTP request.
		
	const std::string& getEncoding() const;
		/// Returns the encoding used to encode the form in the HTTP request.

	const Poco::URI& getURI() const;
		/// Returns the URL of the form
	
	void handleForm(const std::string& field, const std::string& value);
		/// Handles a form field submitted by the client.
		
	void handleForm(const Poco::Net::HTMLForm& form);
		/// Handles a complete form submit
	
	void handleAjaxRequest(const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response);
		/// Handles a complete AJAX request submitted by the client.
	
	bool serializeJSON(std::ostream& out, const std::string&);
	
	void serializeJSONImpl(std::ostream& out);
	
	RequestProcessor* getFormProcessor(const std::string& name);
		/// Returns the requestprocessor or null
		
	void registerFormProcessor(const std::string& name, RequestProcessor* pProc);
		/// Registers a RequestProcessor for a request.
	
			
protected:
	Form(const std::string& name, const std::type_info& type, const Poco::URI& uri);
		/// Creates a Form and assigns it the given name.
		
	Form(const std::type_info& type, const Poco::URI& uri);
		/// Creates a Form.
		
	~Form();
		/// Destroys the Form.
		
private:
	typedef std::map<std::string, RequestProcessor* > RequestProcessorMap;
	std::string         _method;
	std::string         _encoding;
	Poco::URI           _uri;
	RequestProcessorMap _namedChildren;
};


//
// inlines
//
inline const std::string& Form::getMethod() const
{
	return _method;
}


inline const std::string& Form::getEncoding() const
{
	return _encoding;
}


inline const Poco::URI& Form::getURI() const
{
	return _uri;
}


inline bool Form::serializeJSON(std::ostream& out, const std::string&)
{
	serializeJSONImpl(out);
	return true;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Form_INCLUDED
