//
// Delegate.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Delegate.h#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  Delegate
//
// Definition of the Delegate class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Delegate_INCLUDED
#define WebWidgets_Delegate_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/RefCountedObject.h"


namespace Poco {
namespace WebWidgets {


class BasicDelegateImpl;


class WebWidgets_API Delegate
	/// Delegate implements a very simple, lightweight delegate mechanism.
{
public:
	Delegate();
		/// Creates a Delegate for void.
		
	Delegate(const Delegate& delegate);
		/// Creates a Delegate by copying another one.
		
	Delegate(BasicDelegateImpl* pImpl);
		/// Creates a Delegate using the given BasicDelegateImpl.
				
	~Delegate();
		/// Destroys the Delegate.
		
	void swap(Delegate& delegate);
		/// Swaps the Delegate with another one.
		
	Delegate& operator = (const Delegate& delegate);
		/// Assignment operator.
		
	void operator () (void* pSender) const;
		/// Invokes the delegate.
		
	operator void* () const;
	bool operator ! () const;
		
private:
	BasicDelegateImpl* _pImpl;
};


class WebWidgets_API BasicDelegateImpl: public Poco::RefCountedObject
	/// The common base class for all DelegateImpl instantiations.
{
public:
	BasicDelegateImpl();
		/// Creates the BasicDelegateImpl.
	
	virtual void invoke(void* pSender) = 0;
		/// Invokes the delegate.
	
protected:
	~BasicDelegateImpl();
		/// Destroys the Delegate.
};


template <class C>
class DelegateImpl: public BasicDelegateImpl
{
public:
	typedef void (C::*Callback)(void*);
	
	DelegateImpl(C& object, Callback method):
		/// Creates the DelegateImpl
		_pObject(&object),
		_method(method)
	{
	}
	
	void invoke(void* pSender)
	{
		(_pObject->*_method)(pSender);		
	}
	
protected:
	~DelegateImpl()
	{
	}
	
private:
	DelegateImpl();
	
	C* _pObject;
	Callback _method;
};


template <class C>
Delegate delegate(C& object, void (C::*method)(void*))
	/// "Constructor" function for a Delegate.
{
	return Delegate(new DelegateImpl<C>(object, method));
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Delegate_INCLUDED
