//
// ComboBox.h
//
// $Id: //poco/Main/template/class.h#8 $
//
// Library: WebWidgets
// Package: Controls
// Module:  ComboBox
//
// Definition of the ComboBox class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_ComboBox_INCLUDED
#define WebWidgets_ComboBox_INCLUDED


#include "Poco/WebWidgets/TextField.h"
#include "Poco/WebWidgets/ComboBoxCell.h"
#include "Poco/WebWidgets/Event.h"
#include "Poco/WebWidgets/JavaScriptEvent.h"
#include <vector>


namespace Poco {
namespace WebWidgets {


class WebWidgets_API ComboBox: public TextField
	/// A ComboBox stores the data internally in a vector<Poco::Any>
	/// Note that setValue and getValue only refer to the currently selected value.
	/// Also the formatter will only render the currently selected value

{
public:
	typedef Poco::AutoPtr<ComboBox> Ptr;

	typedef Event<ComboBox> ComboBoxEvent;
	typedef ComboBoxCell::OldNewValue SelectEvent; /// a pair of old, then new value
	
	JavaScriptEvent<const Poco::Any> beforeSelect; /// thrown before a new element is selected
	
	JavaScriptEvent<const SelectEvent> selected; /// thrown after a new element is selected
	
	JavaScriptEvent<ComboBoxEvent> afterLoad; // thrown after data was loaded
	
	ComboBox();
		/// Creates the ComboBox.

	ComboBox(const std::string& name);
		/// Creates a named ComboBox

	std::vector<Any>::const_iterator begin() const;
		/// ConstIterator to all elements

	std::vector<Any>::iterator begin();
		/// Iterator to all elements

	std::vector<Any>::const_iterator end() const;
		/// ConstIterator to all elements

	std::vector<Any>::iterator end();
		/// Iterator to all elements

	void setElements(const std::vector<Any>& elems);
		/// Initializes the combo box with the provided elements
	
	template <typename T>	
	void setElements(const std::vector<T>& elems)
		/// Initializes the combo box with the provided elements
	{
		std::vector<Any> result;
		typename std::vector<T>::const_iterator it = elems.begin();
		for (; it != elems.end(); ++it)
			result.push_back(*it);
		setElements(result);
	}

	const std::vector<Any>& getElements() const;
		/// Returns all elements

	void insert(const Any& elem);
		/// Add a single element to the collection

	void erase(const Any& elem);
		/// Removes a single element from the collection.

	void setSelected(const Any& elem);
		/// Selects the element. 

	bool hasSelected() const;
		/// Returns true if a selected element exists

	const Any& getSelected() const;
		/// Returns the selected element, exception if none was selected

protected:
	ComboBox(const std::string& name, const std::type_info& type);
		/// Creates a DateField and assigns it the given name.

	ComboBox(const std::type_info& type);
		/// Creates a DateField.

	~ComboBox();
		/// Destroys the ComboBox.
		
	void fireSelected(const void* pSender, const SelectEvent& oldNewPair);
		/// Fires the selected event.
		
	void fireBeforeSelect(const void* pSender, const Poco::Any& newValue);
		/// Fires the beforeSelect event.
		
	void fireAfterLoad(void* pSender);
		/// Fires the afterLoad event.
		
};


inline bool ComboBox::hasSelected() const
{
	return cell<ComboBoxCell>()->hasSelected();
}


inline std::vector<Any>::const_iterator ComboBox::begin() const
{
	return cell<ComboBoxCell>()->begin();
}


inline std::vector<Any>::iterator ComboBox::begin()
{
	return cell<ComboBoxCell>()->begin();
}


inline std::vector<Any>::const_iterator ComboBox::end() const
{
	return cell<ComboBoxCell>()->end();
}


inline std::vector<Any>::iterator ComboBox::end()
{
	return cell<ComboBoxCell>()->end();
}


inline void ComboBox::setElements(const std::vector<Any>& elems)
{
	cell<ComboBoxCell>()->setElements(elems);
}


inline const std::vector<Any>& ComboBox::getElements() const
{
	return cell<ComboBoxCell>()->getElements();
}


inline void ComboBox::insert(const Any& elem)
{
	cell<ComboBoxCell>()->insert(elem);
}


inline void ComboBox::erase(const Any& elem)
{
	cell<ComboBoxCell>()->erase(elem);
}


inline void ComboBox::setSelected(const Any& elem)
{
	cell<ComboBoxCell>()->setSelected(elem);
}


inline const Any& ComboBox::getSelected() const
{
	return cell<ComboBoxCell>()->getSelected();
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_ComboBox_INCLUDED
