//
// AjaxDelegate.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/AjaxDelegate.h#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  AjaxDelegate
//
// Definition of the AjaxDelegate class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_AjaxDelegate_INCLUDED
#define WebWidgets_AjaxDelegate_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/RefCountedObject.h"


namespace Poco {
	namespace Net {
		class NameValueCollection;
		class HTTPServerResponse;
	}
namespace WebWidgets {


class BasicAjaxDelegateImpl;


struct AjaxParameters
{
	const Poco::Net::NameValueCollection& args;
	Poco::Net::HTTPServerResponse& response;
	bool handled;
	AjaxParameters(const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response);
};


class WebWidgets_API AjaxDelegate
	/// AjaxDelegate implements a very simple, lightweight delegate mechanism.
{
public:
	AjaxDelegate();
		/// Creates a AjaxDelegate for void.
		
	AjaxDelegate(const AjaxDelegate& delegate);
		/// Creates a AjaxDelegate by copying another one.
		
	AjaxDelegate(BasicAjaxDelegateImpl* pImpl);
		/// Creates a AjaxDelegate using the given BasicAjaxDelegateImpl.
				
	~AjaxDelegate();
		/// Destroys the AjaxDelegate.
		
	void swap(AjaxDelegate& delegate);
		/// Swaps the AjaxDelegate with another one.
		
	AjaxDelegate& operator = (const AjaxDelegate& delegate);
		/// Assignment operator.
		
	void operator () (void* pSender, const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response, bool& handled) const;
		/// Invokes the delegate.
		
	operator void* () const;
	bool operator ! () const;
		
private:
	BasicAjaxDelegateImpl* _pImpl;
};


class WebWidgets_API BasicAjaxDelegateImpl: public Poco::RefCountedObject
	/// The common base class for all AjaxDelegateImpl instantiations.
{
public:
	BasicAjaxDelegateImpl();
		/// Creates the BasicAjaxDelegateImpl.
	
	virtual void invoke(void* pSender, AjaxParameters& params) = 0;
		/// Invokes the delegate.
	
protected:
	~BasicAjaxDelegateImpl();
		/// Destroys the AjaxDelegate.
};


template <class C>
class AjaxDelegateImpl: public BasicAjaxDelegateImpl
{
public:
	typedef void (C::*Callback)(void*, AjaxParameters&);
	
	AjaxDelegateImpl(C& object, Callback method):
		/// Creates the AjaxDelegateImpl
		_pObject(&object),
		_method(method)
	{
	}
	
	void invoke(void* pSender, AjaxParameters& params)
	{
		(_pObject->*_method)(pSender, params);		
	}
	
protected:
	~AjaxDelegateImpl()
	{
	}
	
private:
	AjaxDelegateImpl();
	
	C* _pObject;
	Callback _method;
};


template <class C>
AjaxDelegate ajaxDelegate(C& object, void (C::*method)(void*, AjaxParameters&))
	/// "Constructor" function for a AjaxDelegate.
{
	return AjaxDelegate(new AjaxDelegateImpl<C>(object, method));
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_AjaxDelegate_INCLUDED
