//
// ExtJSTest.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/testsuite/src/ExtJSTest.cpp#18 $
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "ExtJSTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/ExtJS/TableCellHandler.h"
#include "Poco/WebWidgets/Page.h"
#include "Poco/WebWidgets/Renderer.h"
#include "Poco/WebWidgets/RenderContext.h"
#include "Poco/WebWidgets/Label.h"
#include "Poco/WebWidgets/Button.h"
#include "Poco/WebWidgets/ImageButton.h"
#include "Poco/WebWidgets/WebApplication.h"
#include "Poco/WebWidgets/Form.h"
#include "Poco/WebWidgets/Panel.h"
#include "Poco/WebWidgets/TextField.h"
#include "Poco/WebWidgets/TextEdit.h"
#include "Poco/WebWidgets/TimeField.h"
#include "Poco/WebWidgets/DateField.h"
#include "Poco/WebWidgets/PasswordField.h"
#include "Poco/WebWidgets/NumberField.h"
#include "Poco/WebWidgets/ComboBox.h"
#include "Poco/WebWidgets/CheckButton.h"
#include "Poco/WebWidgets/CheckButtonCell.h"
#include "Poco/WebWidgets/RadioButton.h"
#include "Poco/WebWidgets/Frame.h"
#include "Poco/WebWidgets/GridLayout.h"
#include "Poco/WebWidgets/HorizontalLayout.h"
#include "Poco/WebWidgets/VerticalLayout.h"
#include "Poco/WebWidgets/Image.h"
#include "Poco/WebWidgets/TabView.h"
#include "Poco/WebWidgets/ListBox.h"
#include "Poco/WebWidgets/Collapsible.h"
#include "Poco/WebWidgets/Table.h"
#include "Poco/WebWidgets/ButtonCell.h"
#include "Poco/WebWidgets/ImageButtonCell.h"
#include "Poco/WebWidgets/TextEditCell.h"
#include "Poco/WebWidgets/SimpleTableModel.h"
#include "Poco/WebWidgets/JSDelegate.h"
#include "Poco/WebWidgets/ResourceManager.h"
#include "Poco/WebWidgets/SubmitButton.h"
#include "Poco/TeeStream.h"
#include "Poco/DateTimeFormat.h"
#include "Poco/DateTime.h"
#include <sstream>
#include <fstream>


using namespace Poco::WebWidgets::ExtJS;
using namespace Poco::WebWidgets;
using namespace Poco;


ExtJSTest::ExtJSTest(const std::string& name): CppUnit::TestCase(name)
{
}


ExtJSTest::~ExtJSTest()
{
}


void ExtJSTest::testPage()
{
	ResourceManager::Ptr pRM(new ResourceManager());
	Utility::initialize(pRM, Poco::Path());
	WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	std::ostringstream ostr;
	std::ofstream fstr("testPage.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);

	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("<html><head><title>test</title>"
								"<script type=\"text/javascript\" src=\"ext-base.js\"></script>"
								"<script type=\"text/javascript\" src=\"ext-all.js\"></script>"
								"<link rel=\"stylesheet\" type=\"text/css\" href=\"resources/css/ext-all.css\"></head>"
								"<body>"
								"</body></html>");
}


void ExtJSTest::testPage2()
{
	ResourceManager::Ptr pRM(new ResourceManager());
	Utility::initialize(pRM, Poco::Path());
	WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("<h1>Hallo</h1>");
	ptr->add(ptrLbl);

	std::ostringstream ostr;
	std::ofstream fstr("testPage2.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("<html><head><title>test</title>"
								"<script type=\"text/javascript\" src=\"ext-base.js\"></script>"
								"<script type=\"text/javascript\" src=\"ext-all.js\"></script>"
								"<link rel=\"stylesheet\" type=\"text/css\" href=\"resources/css/ext-all.css\">"
								"<script type=\"text/javascript\">Ext.onReady(function() {Ext.QuickTips.init();});</script>"
								"</head>"
								"<body>"
								"<h1>Hallo</h1>"
								"</body></html>");
}


void ExtJSTest::testButton()
{
	ResourceManager::Ptr pRM(new ResourceManager());
	Utility::initialize(pRM, Poco::Path());
	WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("<h1>Hallo</h1>");
	ptr->add(ptrLbl);
	Button::Ptr ptrBut (new Button("submit"));
	ptrBut->setText("Submit");
	ptrBut->setToolTip("click here and something horrible will happen");
	ptr->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testButton.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("<html><head>"
								"<title>test</title>"
								"<script type=\"text/javascript\" src=\"ext-base.js\"></script>"
								"<script type=\"text/javascript\" src=\"ext-all.js\"></script>"
								"<link rel=\"stylesheet\" type=\"text/css\" href=\"resources/css/ext-all.css\">"
								"<script type=\"text/javascript\">"
								"Ext.onReady(function() {Ext.QuickTips.init();"
								"new Ext.Button({renderTo: '3', disabled: false, text: 'Submit'});});"
								"</script>"
								"</head><body>"
								"<h1>Hallo</h1>"
								"<div id=\"3\" />"
								"</body></html>");

}


void ExtJSTest::testFormTextField()
{
	ResourceManager::Ptr pRM(new ResourceManager());
	Utility::initialize(pRM, Poco::Path());
	WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First Name");
	ptrFrm->add(ptrLbl);
	TextField::Ptr ptrTxt(new TextField("name"));
	ptrTxt->setPlaceHolder("Insert your first name here");
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for textfield. We do :-)");
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("submit"));
	ptrBut->setText("Submit");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormTextField.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("<html><head>"
								"<title>test</title>"
								"<script type=\"text/javascript\" src=\"ext-base.js\"></script>"
								"<script type=\"text/javascript\" src=\"ext-all.js\"></script>"
								"<link rel=\"stylesheet\" type=\"text/css\" href=\"resources/css/ext-all.css\">"
								"<script type=\"text/javascript\">"
								"Ext.onReady(function() {Ext.QuickTips.init();"
								"new Ext.Button({renderTo: '3', disabled: false, text: 'Submit'});});"
								"</script>"
								"</head><body>"
								"<h1>Hallo</h1>"
								"<div id=\"3\" />"
								"</body></html>");

}


void ExtJSTest::testFormTimeField()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First Name");
	ptrFrm->add(ptrLbl);
	TimeField::Ptr ptrTxt(new TimeField("name"));
	ptrTxt->setPlaceHolder("Insert your birth time here");
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for timefield. We do :-)");
	ptrTxt->setFormat(TimeField::FMT_24H);
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("submit"));
	ptrBut->setText("Submit");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormTimeField.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("");
}


void ExtJSTest::testFormDateField()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("Some Date value");
	ptrFrm->add(ptrLbl);

	DateField::Ptr ptrTxt(new DateField("name"));
	ptrTxt->setPlaceHolder("date");
	ptrTxt->setFormat(Poco::DateTimeFormat::ISO8601_FORMAT);
	DateTime now;
	ptrTxt->setDate(now);
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for datefields. We do :-)");
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("submit"));
	ptrBut->setText("Submit");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormDateField.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("");
}


void ExtJSTest::testFormPassword()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("Some Password Name");
	ptrFrm->add(ptrLbl);
	PasswordField::Ptr ptrTxt(new PasswordField("name"));
	ptrTxt->setPlaceHolder("password");
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for PasswordField. We do :-)");
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("login"));
	ptrBut->setText("Login");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormPassword.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("");
}


void ExtJSTest::testFormNumberField()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("Some Number");
	ptrFrm->add(ptrLbl);
	NumberField::Ptr ptrTxt(new NumberField("name"));
	ptrTxt->setPlaceHolder("numbers only");
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for NumberField. We do :-)");
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("Button"));
	ptrBut->setText("Button");
	ptrBut->setToolTip("This button will do nothing");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormNumberField.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("");
}


void ExtJSTest::testFormComboBox()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("Some Date value");
	ptrFrm->add(ptrLbl);

	ComboBox::Ptr ptrTxt(new ComboBox("name"));
	ptrTxt->setPlaceHolder("select sth");
	ptrTxt->insert(std::string("Wien"));
	ptrTxt->insert(std::string("Crap Town"));
	ptrTxt->insert(std::string("Villach"));
	ptrTxt->insert(std::string("Salzburg"));
	ptrTxt->insert(std::string("Sankt Jakob"));
	ptrTxt->erase(std::string("Crap Town"));
	ptrTxt->setToolTip("tippidutool");
	ptrTxt->setSelected(std::string("Villach"));
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("submit"));
	ptrBut->setText("Submit");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormComboBox.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("");
}



void ExtJSTest::testFormImageButton()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First Name");
	ptrFrm->add(ptrLbl);
	TextField::Ptr ptrTxt(new TextField("name"));
	ptrTxt->setPlaceHolder("Insert your first name here");
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for textfield. We do :-)");
	ptrFrm->add(ptrTxt);
	ImageButton::Ptr ptrBut (new ImageButton("submit"));
	ptrBut->setText("NoPic");
	ptrFrm->add(ptrBut);
	ImageButton::Ptr ptrBut2 (new ImageButton("submit"));
	ptrBut2->setText("Submit");
	ptrBut2->setImage(new Image(Poco::URI("Sunset.jpg")));
	ptrBut2->getImage()->setWidth(32);
	ptrBut2->getImage()->setHeight(32);
	ptrBut2->getImage()->setToolTip("Image tooltip");
	ptrFrm->add(ptrBut2);

	ImageButton::Ptr ptrBut3 (new ImageButton("submit"));
	ptrBut3->setText("HiddenText");
	ptrBut3->setImage(new Image(Poco::URI("Sunset.jpg")));
	ptrBut3->setShowText(false);
	ptrBut3->getImage()->setWidth(32);
	ptrBut3->getImage()->setHeight(32);
	ptrFrm->add(ptrBut3);

	std::ostringstream ostr;
	std::ofstream fstr("testFormImageButton.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}



void ExtJSTest::testFormTextEdit()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First Name");
	ptrFrm->add(ptrLbl);
	TextEdit::Ptr ptrTxt(new TextEdit("name"));
	ptrTxt->setPlaceHolder("Insert your first name here");
	ptrTxt->setToolTip("Per default, ExtJS doesn't support tooltips for textedit. We do :-)");
	ptrFrm->add(ptrTxt);
	Button::Ptr ptrBut (new Button("submit"));
	ptrBut->setText("Submit");
	ptrFrm->add(ptrBut);

	std::ostringstream ostr;
	std::ofstream fstr("testFormTextEdit.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
	static const std::string exp("<html><head>"
								"<title>test</title>"
								"<script type=\"text/javascript\" src=\"ext-base.js\"></script>"
								"<script type=\"text/javascript\" src=\"ext-all.js\"></script>"
								"<link rel=\"stylesheet\" type=\"text/css\" href=\"resources/css/ext-all.css\">"
								"<script type=\"text/javascript\">"
								"Ext.onReady(function() {Ext.QuickTips.init();"
								"new Ext.Button({renderTo: '3', disabled: false, text: 'Submit'});});"
								"</script>"
								"</head><body>"
								"<h1>Hallo</h1>"
								"<div id=\"3\" />"
								"</body></html>");
}



void ExtJSTest::testFormCheckButton()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("<h1>Hallo</h1>");
	ptr->add(ptrLbl);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	CheckButton::Ptr ptrBut (new CheckButton("radio", "Enable", true));
	ptrBut->setToolTip("click here to enable");
	ptrFrm->add(ptrBut);
	CheckButton::Ptr ptrBut2 (new CheckButton("radio", "Disable", false));
	ptrBut2->setToolTip("click here to disable");
	ptrFrm->add(ptrBut2);

	std::ostringstream ostr;
	std::ofstream fstr("testFormCheckButton.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormRadioButton()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("<h1>Hallo</h1>");
	ptr->add(ptrLbl);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	RadioButton::Ptr ptrBut (new RadioButton("radio", "Enable", true));
	ptrBut->setToolTip("click here to enable");
	ptrFrm->add(ptrBut);
	RadioButton::Ptr ptrBut2 (new RadioButton("radio", "Disable", false));
	ptrBut2->setToolTip("click here to disable");
	ptrFrm->add(ptrBut2);

	std::ostringstream ostr;
	std::ofstream fstr("testFormRadioButton.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormGridLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrm->add(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio", "", false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio", "", false));

	std::ostringstream ostr;
	std::ofstream fstr("testFormGridLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormHorizontalLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	HorizontalLayout::Ptr ptrGrid = new HorizontalLayout();
	ptrFrm->add(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));

	std::ostringstream ostr;
	std::ofstream fstr("testFormHorizontalLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormVerticalLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	VerticalLayout::Ptr ptrGrid = new VerticalLayout();
	ptrFrm->add(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));

	std::ostringstream ostr;
	std::ofstream fstr("testFormVerticalLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormFrameGridLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Frame::Ptr ptrFrame = new Frame();
	ptrFrm->add(ptrFrame);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));

	std::ostringstream ostr;
	std::ofstream fstr("testFormFrameGridLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormFrameHorizontalLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Frame::Ptr ptrFrame = new Frame();
	ptrFrm->add(ptrFrame);
	HorizontalLayout::Ptr ptrGrid = new HorizontalLayout();
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","", false));

	std::ostringstream ostr;
	std::ofstream fstr("testFormFrameHorizontalLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormFrameVerticalLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Frame::Ptr ptrFrame = new Frame();
	ptrFrm->add(ptrFrame);
	VerticalLayout::Ptr ptrGrid = new VerticalLayout();
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));

	std::ostringstream ostr;
	std::ofstream fstr("testFormFrameVerticalLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormGridLayoutNullElements()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	GridLayout::Ptr ptrGrid = new GridLayout(3, 0);
	ptrFrm->add(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->set(ptrLbl,2,0);
	ptrGrid->set(new RadioButton("radio","", false),2,2);

	std::ostringstream ostr;
	std::ofstream fstr("testFormGridLayoutNullElements.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormImage()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("<h1>Hallo</h1>");
	ptr->add(ptrLbl);

	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	Image::Ptr ptrImg (new Image("img1", Poco::URI("Sunset.jpg")));
	ptrImg->setText("Image");
	ptrImg->setToolTip("This is just an image");

	ptrFrm->add(ptrImg);
	RadioButton::Ptr ptrBut2 (new RadioButton("radio","",false));
	ptrBut2->setLabel("Disable");
	ptrBut2->setToolTip("click here to disable");
	ptrFrm->add(ptrBut2);

	std::ostringstream ostr;
	std::ofstream fstr("testFormImage.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testTabView()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	TabView::Ptr ptrTab(new TabView("tab1"));
	ptrTab->add(new Image("Image", Poco::URI("Sunset.jpg")));
	ptrTab->setActiveView(0);
	Label::Ptr ptrLbl(new Label("Label"));
	ptrLbl->setText("<h1>Hallo</h1>");
	ptrTab->add(ptrLbl);

	TabView::Ptr ptrTab2(new TabView("TabView"));
	ptrTab->add(ptrTab2);
	ptr->add(ptrTab);
	
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptrTab2->add(ptrFrm);
	ptrTab2->setActiveView(0);
	Image::Ptr ptrImg (new Image("img1", Poco::URI("Sunset.jpg")));
	ptrImg->setText("Image");
	ptrImg->setToolTip("This is just an image");

	ptrFrm->add(ptrImg);
	RadioButton::Ptr ptrBut2 (new RadioButton("radio","",false));
	ptrBut2->setLabel("Disable");
	ptrBut2->setToolTip("click here to disable");
	ptrTab2->add(ptrBut2);

	std::ostringstream ostr;
	std::ofstream fstr("testTabView.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testCollapsible()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Collapsible::Ptr ptrFrame(new Collapsible("collapsible"));
	ptrFrame->setToolTip("This frame shouldn't be initially collapsed");
	ptr->add(ptrFrame);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));

	std::ostringstream ostr;
	std::ofstream fstr("testCollapsible.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testCollapsible2()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Collapsible::Ptr ptrFrame(new Collapsible("This element should be minimized"));
	ptrFrame->setCollapse(true);
	ptrFrame->setToolTip("This frame shouldn't be initially collapsed");
	ptr->add(ptrFrame);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));

	std::ostringstream ostr;
	std::ofstream fstr("testCollapsible2.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testPanel()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Frame::Ptr ptrF = new Frame();
	ptrF->setHeight(600);
	ptrF->setWidth(800);
	ptr->add(ptrF);
	Panel::Ptr ptrFrame(new Panel("MyWindow"));
	ptrFrame->setWidth(640);
	ptrFrame->setHeight(400);
	ptrF->setChild(ptrFrame);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));

	std::ostringstream ostr;
	std::ofstream fstr("testPanel.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testRootPanel()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Panel::Ptr ptrFrame(new Panel("MyWindow"));
	ptrFrame->setWidth(640);
	ptrFrame->setHeight(400);
	ptr->add(ptrFrame);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));

	std::ostringstream ostr;
	std::ofstream fstr("testRootPanel.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}



void ExtJSTest::testNestedPanels()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Panel::Ptr ptrF = new Panel("OuterWindow");
	ptrF->setHeight(600);
	ptrF->setWidth(800);
	ptr->add(ptrF);
	Panel::Ptr ptrFrame(new Panel("MyWindow"));
	ptrFrame->setWidth(640);
	ptrFrame->setHeight(400);
	ptrF->setChild(ptrFrame);
	GridLayout::Ptr ptrGrid = new GridLayout(2, 2);
	ptrFrame->setChild(ptrGrid);
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("First");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));
	ptrLbl = new Label();
	ptrLbl->setText("Second");
	ptrGrid->add(ptrLbl);
	ptrGrid->add(new RadioButton("radio","",false));

	std::ostringstream ostr;
	std::ofstream fstr("testNestedPanels.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}



void ExtJSTest::testListBox()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Frame::Ptr ptrF = new Frame();
	ptrF->setHeight(600);
	ptrF->setWidth(800);
	ptr->add(ptrF);
	ListBox::Ptr ptrList(new ListBox("MyWindow"));
	ptrList->setWidth(640);
	ptrList->setHeight(400);
	ptrF->setChild(ptrList);
	ptrList->insert(std::string("First"), false);
	ptrList->insert(std::string("FirstSelected"), true);
	ptrList->insert(std::string("Second"), false);
	ptrList->insert(std::string("SecondSelected"), true);
	ptrList->selectionChanged.setServerCallback(Poco::WebWidgets::SC_YES);

	std::ostringstream ostr;
	std::ofstream fstr("testListBox.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testFormListBox()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Form::Ptr ptrF = new Form(Poco::URI("/test"));
	ptrF->setHeight(600);
	ptrF->setWidth(800);
	ptr->add(ptrF);
	ListBox::Ptr ptrList(new ListBox("MyWindow"));
	ptrList->setWidth(640);
	ptrList->setHeight(400);
	ptrF->add(ptrList);
	ptrList->insert(std::string("First"), false);
	ptrList->insert(std::string("FirstSelected"), true);
	ptrList->insert(std::string("Second"), false);
	ptrList->insert(std::string("SecondSelected"), true);
	ptrF->add(new SubmitButton("", "Click"));
	std::ostringstream ostr;
	std::ofstream fstr("testFormListBox.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testDateFormatConversion()
{
	std::string result = Utility::convertPocoDateToPHPDate(Poco::DateTimeFormat::ISO8601_FORMAT);
	assert (result == "c");
	//test containing ' , ISO8601 defined as: "%Y-%m-%dT%H:%M:%S%z"
	std::string testISO("time'n'date: " + Poco::DateTimeFormat::ISO8601_FORMAT);
	result = Utility::convertPocoDateToPHPDate(testISO);
	assert (result == "\\t\\i\\me\\'\\n\\'\\d\\a\\te: Y-m-d\\TH:i:sP");
}


void ExtJSTest::testFunction()
{
	Page::Ptr ptr = new Page("test");
	Label::Ptr ptrLbl(new Label());
	ptrLbl->setText("<h1>Hallo</h1>");
	ptr->add(ptrLbl);
	Form::Ptr ptrFrm(new Form("theForm",Poco::URI("/url.php")));
	ptr->add(ptrFrm);
	CheckButton::Ptr ptrBut (new CheckButton("radio", "Enable", true));
	ptrBut->setToolTip("click here to enable");
	ptrFrm->add(ptrBut);
	CheckButton::Ptr ptrBut2 (new CheckButton("radio", "Disable", false));
	ptrBut2->setToolTip("click here to disable");
	ptrFrm->add(ptrBut2);
	TableCellHandler<CheckButtonCell>::Ptr pHandle(new TableCellHandler<CheckButtonCell>("Ext.form.Checkbox", false, true));
	pHandle->addDynamic<bool>("checked", &CheckButtonCell::getBool);
	pHandle->addFixed("dummy", "dummy");
	std::ostringstream str;
	pHandle->writeData(ptrBut->cell<CheckButtonCell>(), str);
	std::string result(str.str());
	std::ostringstream strFct;
	pHandle->writeDynamicData(strFct);
	std::string jsMethod(strFct.str());
	assert (result == "1");
	assert (jsMethod == "function (val){var tmp = new Ext.form.Checkbox({renderTo:'tmp',checked:val,dummy:dummy});var html = Ext.get('tmp').dom.innerHTML;Ext.destroy(tmp);return html;}");
}


void ExtJSTest::testTable()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Table::TableColumns tc;
	tc.push_back(new TableColumn(0, "StaticText"));
	tc.push_back(new TableColumn(new CheckButtonCell(0, "Const", true), "CheckButton"));
	Table::Ptr pTable = new Table(tc, new SimpleTableModel(2));
	pTable->setValue(std::string("one"), 0,0);
	pTable->setValue(std::string("two"), 1,0);
	pTable->setValue(std::string("three"), 2,0);
	pTable->setValue(true, 0,1);
	pTable->setValue(false, 1,1);
	pTable->setValue(true, 2,1);
	ptr->add(pTable);
	std::ostringstream ostr;
	std::ofstream fstr("testTable.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testTableEdit()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Table::TableColumns tc;
	tc.push_back(new TableColumn(new TextFieldCell(0), "DynText"));
	tc.push_back(new TableColumn(new CheckButtonCell(0, "Const", true), "CheckButton"));
	Table::Ptr pTable = new Table(tc, new SimpleTableModel(2));
	pTable->setValue(std::string("one"), 0,0);
	pTable->setValue(std::string("two"), 1,0);
	pTable->setValue(std::string("three"), 2,0);
	pTable->setValue(true, 0,1);
	pTable->setValue(false, 1,1);
	pTable->setValue(true, 2,1);
	ptr->add(pTable);
	std::ostringstream ostr;
	std::ofstream fstr("testTableEdit.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testTableComboBox()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Table::TableColumns tc;
	ComboBoxCell::Ptr pCom = new ComboBoxCell(0);
	pCom->insert(std::string("1"));
	pCom->insert(std::string("2"));
	pCom->insert(std::string("3"));
	tc.push_back(new TableColumn(pCom, "DynText"));
	tc.push_back(new TableColumn(new CheckButtonCell(0, "Const", true), "CheckButton"));
	Table::Ptr pTable = new Table(tc, new SimpleTableModel(2));
	pTable->setValue(std::string("1"), 0,0);
	pTable->setValue(std::string("2"), 1,0);
	pTable->setValue(std::string("3"), 2,0);
	pTable->setValue(true, 0,1);
	pTable->setValue(false, 1,1);
	pTable->setValue(true, 2,1);
	ptr->add(pTable);
	std::ostringstream ostr;
	std::ofstream fstr("testTableComboBox.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testTableButton()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Table::TableColumns tc;
	tc.push_back(new TableColumn(new ButtonCell(0), "ButtonText"));
	tc.push_back(new TableColumn(new CheckButtonCell(0, "Const", true), "CheckButton"));
	Table::Ptr pTable = new Table(tc, new SimpleTableModel(2));
	pTable->setValue(std::string("one"), 0,0);
	pTable->setValue(std::string("two"), 1,0);
	pTable->setValue(std::string("three"), 2,0);
	pTable->setValue(true, 0,1);
	pTable->setValue(false, 1,1);
	pTable->setValue(true, 2,1);
	ptr->add(pTable);
	std::ostringstream ostr;
	std::ofstream fstr("testTableButton.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testTableImageButton()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Table::TableColumns tc;
	tc.push_back(new TableColumn(new ImageButtonCell(0,new Image(Poco::URI("dummy.jpg")))));
	tc.push_back(new TableColumn(new CheckButtonCell(0, "Const", true), "CheckButton"));
	Table::Ptr pTable = new Table(tc, new SimpleTableModel(2));
	pTable->setValue(std::string("Sunset.jpg"), 0,0);
	pTable->setValue(std::string("Sunset.jpg"), 1,0);
	pTable->setValue(std::string("Sunset.jpg"), 2,0);
	pTable->setValue(true, 0,1);
	pTable->setValue(false, 1,1);
	pTable->setValue(true, 2,1);
	ptr->add(pTable);
	std::ostringstream ostr;
	std::ofstream fstr("testTableImageButton.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testJSEvent()
{
	Button::Ptr pBut(new Button());
	pBut->buttonClicked.add(jsDelegate("someFunction")); 
	pBut->buttonClicked.add(jsDelegate("someFunction2(obj)")); 
	pBut->buttonClicked.add(jsDelegate("hello(obj){alert('Click');}")); //hello must get renamed to function
	std::ostringstream out;
	Utility::writeJSEvent(out, "clicked", pBut->buttonClicked.jsDelegates(),0, false);
	std::string result(out.str());
	static const std::string expected("'clicked':"
										"{"
											"fn:function(p1){"
												"var all={"
													"d0:someFunction,"
													"d1:someFunction2,"
													"d2:function(obj){"
														"alert('Click');"
														"},"
													"invoke:function(p1){"
														"this.d0(p1);"
														"this.d1(p1);"
														"this.d2(p1);"
														"}"
													"};"
												"all.invoke(p1);"
											"}"
										"}");
	assert (result == expected);
}


void ExtJSTest::testJSEvent2()
{
	Button::Ptr pBut(new Button());
	pBut->buttonClicked.add(jsDelegate("someFunction")); 
	pBut->buttonClicked.add(jsDelegate("someFunction2(obj,o2)")); 
	pBut->buttonClicked.add(jsDelegate("hello(obj){alert('Click');}")); //hello must get renamed to function
	std::ostringstream out;
	Utility::writeJSEvent(out, "clicked", pBut->buttonClicked.jsDelegates(),0, false);
	std::string result(out.str());
	static const std::string expected("'clicked':"
										"{"
											"fn:function(p2,p1){"
												"var all={"
													"d0:someFunction,"
													"d1:someFunction2,"
													"d2:function(obj){"
														"alert('Click');"
														"},"
													"invoke:function(p2,p1){"
														"this.d0(p2,p1);"
														"this.d1(p2,p1);"
														"this.d2(p2,p1);"
														"}"
													"};"
												"all.invoke(p2,p1);"
											"}"
										"}");
	assert (result == expected);
}


void ExtJSTest::testButtonRename()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Button::Ptr pBut(new Button("but1", "Not Clicked"));
	ptr->add(pBut);
	{
		std::ostringstream ostr;
		ostr << "function() {";
		ostr <<		"var but=Ext.getCmp('" << pBut->id() << "');";
		ostr <<		"if (but.getText() == 'Clicked') ";
		ostr <<			"but.setText('Not Clicked');";
		ostr <<		"else ";
		ostr <<			"but.setText('Clicked');";
		ostr <<	"}";
		pBut->buttonClicked.add(jsDelegate(ostr.str())); 
	}
	std::ostringstream ostr;
	std::ofstream fstr("testButtonRename.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testPanelShowHide()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	Button::Ptr pBut(new Button("but1", "Show"));
	ptr->add(pBut);
	Panel::Ptr pWin(new Panel("p","Test Panel"));
	pWin->setChild(new Label("lbl1", "Just some dummy text"));
	pWin->show(false);
	ptr->add(pWin);
	{
		std::ostringstream ostr;
		ostr << "function() {";
		ostr <<		"var but=Ext.getCmp('" << pBut->id() << "');";
		ostr <<		"var win=Ext.getCmp('" << pWin->id() << "');";
		ostr <<		"if (but.getText()=='Show'){";
		ostr <<			"but.setText('Hide');";
		ostr <<			"win.show();";
		ostr <<		"}else{";
		ostr <<			"but.setText('Show');";
		ostr <<			"win.hide();";
		ostr <<		"}";
		ostr <<	"}";
		pBut->buttonClicked.add(jsDelegate(ostr.str())); 
	}
	
	std::ostringstream ostr;
	std::ofstream fstr("testPanelShowHide.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testHorizontalLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	HorizontalLayout::Ptr pHor(new HorizontalLayout(1));
	pHor->add(new Button("b1", "But1"));
	pHor->add(new Button("b2", "But2"));
	pHor->add(new Button("b3", "But3"));
	pHor->add(new Button("b4", "But4"));
	ptr->add(pHor);
	std::ostringstream ostr;
	std::ofstream fstr("testHorizontalLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testVerticalLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	VerticalLayout::Ptr pHor(new VerticalLayout(10));
	pHor->add(new Button("b1", "But1"));
	pHor->add(new Button("b2", "But2"));
	pHor->add(new Button("b3", "But3"));
	pHor->add(new Button("b4", "But4"));
	ptr->add(pHor);
	std::ostringstream ostr;
	std::ofstream fstr("testVerticalLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testGridLayout()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	GridLayout::Ptr pHor(new GridLayout(2));
	pHor->setHorizontalPadding(30);
	pHor->setVerticalPadding(15);
	pHor->add(new Button("b1", "But1"));
	pHor->add(new Button("b2", "But2"));
	pHor->add(new Button("b3", "But3"));
	pHor->add(new Button("b4", "But4"));
	ptr->add(pHor);
	std::ostringstream ostr;
	std::ofstream fstr("testGridLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::testGridLayout2()
{
	ResourceManager::Ptr pRM(new ResourceManager());Utility::initialize(pRM, Poco::Path());WebApplication webApp(Poco::URI("/"), pRM);
	LookAndFeel::Ptr laf(new LookAndFeel());
	webApp.setLookAndFeel(laf);
	RenderContext context(*laf, webApp);
	Utility::initialize(laf);

	Page::Ptr ptr = new Page("test");
	webApp.setCurrentPage(ptr);
	GridLayout::Ptr pHor(new GridLayout(5,2));
	pHor->setHorizontalPadding(30);
	pHor->setVerticalPadding(15);
	pHor->add(new Label("", "txt"));
	pHor->add(new Button("b1", "But1"));
	pHor->add(new Button("b2", "But2"));
	pHor->add(new Button("b3", "But3"));
	pHor->add(new Button("b4", "But4"));
	ptr->add(pHor);
	std::ostringstream ostr;
	std::ofstream fstr("testGridLayout.html");
	TeeOutputStream out(ostr);
	out.addStream(fstr);
	ptr->renderHead(context, out);
	ptr->renderBody(context, out);
	std::string result = ostr.str();
}


void ExtJSTest::setUp()
{
}


void ExtJSTest::tearDown()
{
}


CppUnit::Test* ExtJSTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("ExtJSTest");

	CppUnit_addTest(pSuite, ExtJSTest, testPage);
	CppUnit_addTest(pSuite, ExtJSTest, testPage2);
	CppUnit_addTest(pSuite, ExtJSTest, testButton);
	CppUnit_addTest(pSuite, ExtJSTest, testFormTextField);
	CppUnit_addTest(pSuite, ExtJSTest, testFormTimeField);
	CppUnit_addTest(pSuite, ExtJSTest, testFormDateField);
	CppUnit_addTest(pSuite, ExtJSTest, testFormPassword);
	CppUnit_addTest(pSuite, ExtJSTest, testFormNumberField);
	CppUnit_addTest(pSuite, ExtJSTest, testFormComboBox);
	CppUnit_addTest(pSuite, ExtJSTest, testFormImageButton);
	CppUnit_addTest(pSuite, ExtJSTest, testFormTextEdit);
	CppUnit_addTest(pSuite, ExtJSTest, testFormCheckButton);
	CppUnit_addTest(pSuite, ExtJSTest, testFormRadioButton);
	CppUnit_addTest(pSuite, ExtJSTest, testFormGridLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testFormHorizontalLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testFormVerticalLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testFormFrameGridLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testFormFrameHorizontalLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testFormFrameVerticalLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testFormGridLayoutNullElements);
	CppUnit_addTest(pSuite, ExtJSTest, testFormImage);
	CppUnit_addTest(pSuite, ExtJSTest, testFormListBox);
	CppUnit_addTest(pSuite, ExtJSTest, testDateFormatConversion);
	CppUnit_addTest(pSuite, ExtJSTest, testCollapsible);
	CppUnit_addTest(pSuite, ExtJSTest, testCollapsible2);
	CppUnit_addTest(pSuite, ExtJSTest, testPanel);
	CppUnit_addTest(pSuite, ExtJSTest, testRootPanel);
	CppUnit_addTest(pSuite, ExtJSTest, testNestedPanels);
	CppUnit_addTest(pSuite, ExtJSTest, testListBox);

	CppUnit_addTest(pSuite, ExtJSTest, testTabView);
	CppUnit_addTest(pSuite, ExtJSTest, testFunction);
	CppUnit_addTest(pSuite, ExtJSTest, testTable);
	CppUnit_addTest(pSuite, ExtJSTest, testTableEdit);
	CppUnit_addTest(pSuite, ExtJSTest, testTableComboBox);
	CppUnit_addTest(pSuite, ExtJSTest, testTableButton);
	CppUnit_addTest(pSuite, ExtJSTest, testTableImageButton);
	CppUnit_addTest(pSuite, ExtJSTest, testJSEvent);
	CppUnit_addTest(pSuite, ExtJSTest, testJSEvent2);
	CppUnit_addTest(pSuite, ExtJSTest, testButtonRename);
	CppUnit_addTest(pSuite, ExtJSTest, testPanelShowHide);
	CppUnit_addTest(pSuite, ExtJSTest, testHorizontalLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testGridLayout);
	CppUnit_addTest(pSuite, ExtJSTest, testGridLayout2);
	CppUnit_addTest(pSuite, ExtJSTest, testVerticalLayout);

	return pSuite;
}
