//
// TimeFieldCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/TimeFieldCellRenderer.cpp#4 $
//
// Library: ExtJS
// Package: Core
// Module:  TimeFieldCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/TimeFieldCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/TextFieldCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/TimeFieldCell.h"
#include "Poco/WebWidgets/WebApplication.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


TimeFieldCellRenderer::TimeFieldCellRenderer()
{
}


TimeFieldCellRenderer::~TimeFieldCellRenderer()
{
}



void TimeFieldCellRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::TimeFieldCell));
	const TimeFieldCell* pCell = static_cast<const Poco::WebWidgets::TimeFieldCell*>(pRenderable);

	ostr << "new Ext.form.TimeField({";

	TimeFieldCellRenderer::writeCellProperties(pCell, ostr);
	ostr << "})";
	if (pCell->getOwner() && !pCell->getOwner()->getName().empty())
	{
		WebApplication::instance().registerFormProcessor(pCell->getOwner()->getName(), const_cast<TimeFieldCell*>(pCell));
	}
}


void TimeFieldCellRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void TimeFieldCellRenderer::writeCellProperties(const TimeFieldCell* pCell, std::ostream& ostr)
{
	TextFieldCellRenderer::writeCellProperties(pCell, ostr);
	TimeField::Format fmt = pCell->getFormat();
	static const std::string fmt24h("'H:i'");
	static const std::string fmt24hs("'H:i:s'");
	static const std::string fmtAmPms("'h:i:s A'");
	static const std::string fmt12h("'h:i'");
	if (fmt == TimeField::FMT_24H)
		ostr << ",format:" << fmt24h;
	else if (fmt == TimeField::FMT_24H_WITHSECONDS)
		ostr << ",format:" << fmt24hs;
	else if (fmt == TimeField::FMT_AMPM_WITHSECONDS)
		ostr << ",format:" << fmtAmPms;
	else if (fmt == TimeField::FMT_12H)
		ostr << ",format:" << fmt12h << ",minValue:'00:00', maxValue:'11:59'";
	else
		; // this is the default	
}


} } } // namespace Poco::WebWidgets::ExtJS
