//
// TextFieldCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/TextFieldCellRenderer.cpp#6 $
//
// Library: ExtJS
// Package: Core
// Module:  TextFieldCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/TextFieldCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/WebWidgets/TextField.h"
#include "Poco/WebWidgets/Control.h"
#include "Poco/WebWidgets/Form.h"
#include "Poco/WebWidgets/WebApplication.h"
#include "Poco/WebWidgets/RequestHandler.h"
#include "Poco/NumberFormatter.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


const std::string TextFieldCellRenderer::EV_TEXTCHANGED("change");


TextFieldCellRenderer::TextFieldCellRenderer()
{
}


TextFieldCellRenderer::~TextFieldCellRenderer()
{
}


void TextFieldCellRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::TextFieldCell));
	const TextFieldCell* pCell = static_cast<const Poco::WebWidgets::TextFieldCell*>(pRenderable);
	ostr << "new Ext.form.TextField({";

	TextFieldCellRenderer::writeCellProperties(pCell, ostr);
	ostr << "})";
	if (pCell->getOwner() && !pCell->getOwner()->getName().empty())
	{
		WebApplication::instance().registerFormProcessor(pCell->getOwner()->getName(), const_cast<TextFieldCell*>(pCell));
	}
}


void TextFieldCellRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void TextFieldCellRenderer::writeCellProperties(const TextFieldCell* pCell, std::ostream& ostr, bool writeValue, bool writeListeners)
{
	View* pOwner = pCell->getOwner();
	Utility::writeCellProperties(pCell, ostr);
	if (pCell->getEditMode() == Cell::EM_SELECTCONTENT)
		ostr << ",selectOnFocus:true";

	if (writeValue&& !pCell->getValue().empty())
	{
		ostr << ",value:'" << Utility::safe(pCell->getString()) << "'";
	}
	
	if (!pCell->isEditable())
		ostr << ",readOnly:true";

	if (!pCell->getPlaceHolder().empty())
		ostr << ",emptyText:'" << Utility::safe(pCell->getPlaceHolder()) << "'";

	if (pCell->getMaxLength() > 0)
		ostr << ",maxLength:" << pCell->getMaxLength();

	if (writeListeners)
	{
		//tooltip is not supported by textField, add listeners
		std::string tooltip (pCell->getToolTip());
		
		TextField* pText = dynamic_cast<TextField*>(pOwner);
			
		if (!tooltip.empty() || (pText && pText->textChanged.hasJavaScriptCode()))
		{
			ostr << ",listeners:{";
			bool comma = false;
			if (!tooltip.empty())
			{
				comma = true;
				ostr << "render:function(c){Ext.QuickTips.register({target:c.getEl(),text:'" << Utility::safe(tooltip) << "'});}";
			}
			if (pText && pText->textChanged.hasJavaScriptCode())
			{
				if (comma)
					ostr << ",";
				Utility::writeJSEvent(ostr, EV_TEXTCHANGED, pText->textChanged, &TextFieldCellRenderer::createTextChangedServerCallback, pText);
			}
			
			
			ostr << "}"; // close listeners
		}
		
		if (pOwner)
			WebApplication::instance().registerAjaxProcessor(Poco::NumberFormatter::format(pOwner->id()), const_cast<TextFieldCell*>(pCell));
	}
}


Poco::WebWidgets::JSDelegate TextFieldCellRenderer::createTextChangedServerCallback(const TextField* pText)
{
	// change : ( Ext.form.Field field, Mixed newVal, Mixed oldVal )
	static const std::string signature("function(field,newVal,oldVal)");
	std::map<std::string, std::string> addParams;
	addParams.insert(std::make_pair(TextFieldCell::FIELD_OLDVAL, "+escape(oldVal)"));
	addParams.insert(std::make_pair(TextFieldCell::FIELD_NEWVAL, "+escape(newVal)"));
	addParams.insert(std::make_pair(RequestHandler::KEY_EVID, TextFieldCell::EV_TEXTCHANGED));
	return Utility::createServerCallback(signature, addParams, pText->id(), pText->textChanged.getOnSuccess(), pText->textChanged.getOnFailure());
}


} } } // namespace Poco::WebWidgets::ExtJS
