//
// ImageRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/ImageRenderer.cpp#3 $
//
// Library: ExtJS
// Package: Core
// Module:  ImageRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/ImageRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/Image.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


ImageRenderer::ImageRenderer()
{
}


ImageRenderer::~ImageRenderer()
{
}


void ImageRenderer::renderHead(const Renderable* pRenderable, const RenderContext&, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::Image));
	const Image* pImage = static_cast<const Poco::WebWidgets::Image*>(pRenderable);
	ostr << "new Ext.Panel({border:false,bodyBorder:false,";
	ostr << "id:'" << pImage->id() << "',";
	if (pImage->hasPosition())
		ostr << ",x:" << pImage->getPosition().posX << ",y:" << pImage->getPosition().posY;
	ostr << "html:";
	writeHTML(pImage, ostr);
	ostr << ",closeAction:'hide'";
	if (!pImage->isVisible())
	{
		ostr << ",hidden:true";
	}
	ostr << "})";
}



void ImageRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void ImageRenderer::writeHTML(const Image* pImage, std::ostream& ostr)
{
	ostr << "'<img src=\"" << Utility::safe(pImage->getURI().toString()) << "\" ";
	std::string txt(pImage->getText());
	if (!txt.empty())
		ostr << "alt=\"" << txt << "\" ";
	std::string tooltip(pImage->getToolTip());
	if (!tooltip.empty())
		ostr << "title=\"" << tooltip << "\" ";
	ostr << "/>'";
}


} } } // namespace Poco::WebWidgets::ExtJS
