//
// ImageButtonCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/ImageButtonCellRenderer.cpp#5 $
//
// Library: ExtJS
// Package: Core
// Module:  ImageButtonCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/ImageButtonCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/ImageButtonCell.h"
#include "Poco/WebWidgets/ImageButton.h"
#include <sstream>


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


ImageButtonCellRenderer::ImageButtonCellRenderer()
{
}


ImageButtonCellRenderer::~ImageButtonCellRenderer()
{
}


void ImageButtonCellRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::ImageButtonCell));
	const ImageButtonCell* pButtonCell = static_cast<const Poco::WebWidgets::ImageButtonCell*>(pRenderable);
	Image::Ptr ptrImg = pButtonCell->getImage();
	bool hasImg = ptrImg && !ptrImg->getURI().empty();
	if (!hasImg)
		ostr << "new Ext.Button({";
	else
		ostr << "new Ext.Panel({border:false,bodyBorder:false,";

	if (!hasImg) // write a normal button
		ButtonCellRenderer::renderHead(pButtonCell, context, ostr);
	else
	{
		const View* pOwner = pButtonCell->getOwner();
		poco_check_ptr (pOwner);
		ostr << "id:'" << pOwner->id() << "'";
		if (pOwner->hasPosition())
			ostr << ",x:" << pOwner->getPosition().posX << ",y:" << pOwner->getPosition().posY;
		ostr << ",html:";
		bool showTxt = pButtonCell->getShowText() || !hasImg;
		writeHTML(pButtonCell, showTxt, ostr);
	}

	ostr << "})";
}


void ImageButtonCellRenderer::writeHTML(const ImageButtonCell* pButtonCell, bool showTxt, std::ostream& ostr)
{
	Image::Ptr pImg = pButtonCell->getImage();
	const Poco::WebWidgets::ImageButton* pOwner = static_cast<const Poco::WebWidgets::ImageButton*>(pButtonCell->getOwner());
	poco_check_ptr (pOwner);
	if (pOwner->hasClass())
		ostr << "'<div class=\"" << Utility::safe(pOwner->getClass()) << "\">";
	ostr << "'<div>";
	ostr << "<div><center>";
	ostr << "<input src=\"" << Utility::safe(pImg->getURI().toString()) << "\"";
	if (!pOwner->getName().empty())
		ostr << " name=\"" << pOwner->getName() << "\"";
	if (pOwner->getWidth() > 0)
		ostr << " width=\"" << pOwner->getWidth() << "\"";
	if (pOwner->getHeight() > 0)
		ostr << " height=\"" << pOwner->getHeight() << "\"";
	if (pImg->hasClass())
		ostr << " class=\"" << pImg->getClass() << "\"";
	std::string tooltip = pOwner->getToolTip();
	if (!tooltip.empty())
		ostr << " alt=\"" << Utility::safe(tooltip) << "\"";

	if (pOwner->buttonClicked.hasJavaScriptCode())
	{
		ostr << " onclick=\"";
		std::ostringstream str;
		//FIXME: this will only work without params!
		Utility::writeFunctionCode(str, "fct", pOwner->buttonClicked, &ButtonCellRenderer::createClickServerCallback, pOwner);
		ostr << Utility::safe(str.str());
		ostr << "\"";
	}
	ostr << " type=\"image\"/>";
	ostr << "</center></div>";
	std::string txt(pOwner->getText());
	if (showTxt && !txt.empty())
		ostr << "<div><center>" << Utility::safe(pButtonCell->getOwner()->getText()) << "</center></div>";
	ostr << "</div>'";
}


void ImageButtonCellRenderer::writeConfigData(const Cell* pCell, const RenderContext& context, std::ostream& ostr)
{

}


} } } // namespace Poco::WebWidgets::ExtJS
