//
// FrameRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/FrameRenderer.cpp#2 $
//
// Library: ExtJS
// Package: Core
// Module:  FrameRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/FrameRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/Frame.h"
#include "Poco/WebWidgets/Layout.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


FrameRenderer::FrameRenderer()
{
}


FrameRenderer::~FrameRenderer()
{
}


void FrameRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	const Frame* pPanel = static_cast<const Poco::WebWidgets::Frame*>(pRenderable);
	ostr << "new Ext.Panel({";

	writeProperties(pPanel, ostr);
	// a frame has exactly one child
	// if this child is a layout we are fine otherwise we have to generate the items array
	View::Ptr pChild = pPanel->getChild();
	if (pChild)
	{
		Layout::Ptr pLayout = pChild.cast<Layout>();
		if (pLayout)
		{
			ostr << ",";
			pLayout->renderHead(context, ostr);
		}
		else
		{
			ostr << ",items:[";
			pChild->renderHead(context, ostr);
			ostr << "]";
		}
	}
	ostr << "})";
}


void FrameRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void FrameRenderer::writeProperties(const Frame* pFrame, std::ostream& ostr)
{
	Utility::writeRenderableProperties(pFrame, ostr);
	ostr << ",frame:true,header:true,autoScroll:true";
	if (pFrame->getWidth() > 0)
		ostr << ",width:" << pFrame->getWidth();
	else
		ostr << ",width:'auto'";
	if (pFrame->getHeight() > 0)
		ostr << ",height:" << pFrame->getHeight();
	else
		ostr << ",height:'auto'";
	if (!pFrame->getTitle().empty())
		ostr << ",title:'" << pFrame->getTitle() << "'";
	if (pFrame->collapsible())
		ostr << ",collapsible:true";
	if (pFrame->collapsed())
		ostr << ",collapsed:true";
	if (!pFrame->isVisible())
		ostr << ",hidden:true";
	if (pFrame->hasPosition())
		ostr << ",x:" << pFrame->getPosition().posX << ",y:" << pFrame->getPosition().posY;
	if (pFrame->hasClass())
		ostr << ",cls:'" << pFrame->getClass() << "'";
	if (!pFrame->showBorder())
		ostr << ",border:false,bodyBorder:false";
}


} } } // namespace Poco::WebWidgets::ExtJS
