//
// TableCellHandlerFactory.h
//
// $Id: //poco/Main/WebWidgets/ExtJS/include/Poco/WebWidgets/ExtJS/TableCellHandlerFactory.h#1 $
//
// Library: ExtJS
// Package: Core
// Module:  TableCellHandlerFactory
//
// Definition of the TableCellHandlerFactory class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ExtJS_TableCellHandlerFactory_INCLUDED
#define ExtJS_TableCellHandlerFactory_INCLUDED


#include "Poco/WebWidgets/ExtJS/TableCellHandler.h"
#include "Poco/WebWidgets/Cell.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


class TableCellHandlerFactory
	/// TableCellHandlerFactory
{
public:
	static TableCellHandlerFactory& instance();
		/// Returns an instance of the TableCellHandlerFactory

	AbstractTableCellHandler::Ptr factory(const Cell::Ptr& t) const;
		/// Retrieves a factory for a given type, throws an exception if no factory is found

	void registerFactory(const Type& t, AbstractTableCellHandler::Ptr ptr);
		/// Registers a factory for the given type, overwrites existing ones

	void registerFactory(const std::type_info& t, AbstractTableCellHandler::Ptr ptr);
		/// Registers a factory for the given type, overwrites existing ones

private:
	typedef std::map<Type, AbstractTableCellHandler::Ptr> Handlers;
	typedef Handlers::iterator Iterator;
	typedef Handlers::const_iterator ConstIterator;

	TableCellHandlerFactory();
	TableCellHandlerFactory(const TableCellHandlerFactory&);
	TableCellHandlerFactory& operator=(const TableCellHandlerFactory&);
	~TableCellHandlerFactory();

private:
	Handlers _handlers;
};


} } } // namespace Poco::WebWidgets::ExtJS


#endif // ExtJS_TableCellHandlerFactory_INCLUDED
