//
// CertificateHandlerFactory.h
//
// $Id: //poco/Main/NetSSL_OpenSSL/include/Poco/Net/CertificateHandlerFactory.h#8 $
//
// Library: NetSSL_OpenSSL
// Package: SSLCore
// Module:  CertificateHandlerFactory
//
// Definition of the CertificateHandlerFactory class.
//
// Copyright (c) 2006-2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef NetSSL_CertificateHandlerFactory_INCLUDED
#define NetSSL_CertificateHandlerFactory_INCLUDED


#include "Poco/Net/NetSSL.h"


namespace Poco {
namespace Net {


class InvalidCertificateHandler;


class NetSSL_API CertificateHandlerFactory
	/// A CertificateHandlerFactory is responsible for creating InvalidCertificateHandlers.
	///
	/// You don't need to access this class directly. Use the macro
	///     POCO_REGISTER_CHFACTORY(namespace, InvalidCertificateHandlerName) 
	/// instead (see the documentation of InvalidCertificateHandler for an example).
{
public:
	CertificateHandlerFactory();
		/// Creates the CertificateHandlerFactory.

	virtual ~CertificateHandlerFactory();
		/// Destroys the CertificateHandlerFactory.

	virtual InvalidCertificateHandler* create(bool server) const = 0;
		/// Creates a new InvalidCertificateHandler. Set server to true if the certificate handler is used on the server side.
};


class NetSSL_API CertificateHandlerFactoryRegistrar
	/// Registrar class which automatically registers CertificateHandlerFactory at the CertificateHandlerFactoryMgr.
	/// You don't need to access this class directly. Use the macro
	///     POCO_REGISTER_CHFACTORY(namespace, InvalidCertificateHandlerName) 
	/// instead (see the documentation of InvalidCertificateHandler for an example).
{
public:
	CertificateHandlerFactoryRegistrar(const std::string& name, CertificateHandlerFactory* pFactory);
		/// Registers the CertificateHandlerFactory with the given name at the factory manager.

	virtual ~CertificateHandlerFactoryRegistrar();
		/// Destroys the CertificateHandlerFactoryRegistrar.
};


template <typename T>
class CertificateHandlerFactoryImpl: public Poco::Net::CertificateHandlerFactory
{
public:
	CertificateHandlerFactoryImpl()
	{
	}

	~CertificateHandlerFactoryImpl()
	{
	}

	InvalidCertificateHandler* create(bool server) const
	{
		return new T(server);
	}
};


} } // namespace Poco::Net


// DEPRECATED: register the factory directly at the FactoryMgr:
// Poco::Net::SSLManager::instance().certificateHandlerFactoryMgr().setFactory(name, new Poco::Net::CertificateHandlerFactoryImpl<MyConsoleHandler>());
#define POCO_REGISTER_CHFACTORY(API, PKCLS)		\
	static Poco::Net::CertificateHandlerFactoryRegistrar aRegistrar(std::string(#PKCLS), new Poco::Net::CertificateHandlerFactoryImpl<PKCLS>());


#endif // NetSSL_CertificateHandlerFactory_INCLUDED
