//
// Mail.cpp
//
// $Id: //poco/svn/Net/samples/SMTPLogger/src/SMTPLogger.cpp#1 $
//
// This sample demonstrates the SMTPChannel class.
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Net/MailMessage.h"
#include "Poco/Net/SMTPChannel.h"
#include "Poco/Logger.h"
#include "Poco/Path.h"
#include "Poco/AutoPtr.h"
#include "Poco/Exception.h"
#include <iostream>


using Poco::Net::SMTPChannel;
using Poco::Logger;
using Poco::Path;
using Poco::AutoPtr;
using Poco::Exception;


#if defined(POCO_OS_FAMILY_UNIX)
const std::string fileName = "${POCO_BASE}/Net/samples/SMTPLogger/logo.gif";
#elif defined(POCO_OS_FAMILY_WINDOWS)
const std::string fileName = "%POCO_BASE%/Net/samples/SMTPLogger/logo.gif";
#endif


int main(int argc, char** argv)
{
	if (argc != 4)
	{
		Path p(argv[0]);
		std::cerr << "usage: " << p.getBaseName() << " <mailhost> <sender> <recipient>" << std::endl;
		std::cerr << "       Send an email log entry from <sender> to <recipient>," << std::endl;
		std::cerr << "       the SMTP server at <mailhost>." << std::endl;
		return 1;
	}
	
	std::string mailhost(argv[1]);
	std::string sender(argv[2]);
	std::string recipient(argv[3]);
	std::string attachment = Path::expand(fileName);

	try
	{
		AutoPtr<SMTPChannel> pSMTPChannel = new SMTPChannel(mailhost, sender, recipient);
		pSMTPChannel->setProperty("attachment", attachment);
		pSMTPChannel->setProperty("type", "image/gif");
		pSMTPChannel->setProperty("delete", "false");
		pSMTPChannel->setProperty("throw", "true");

		Logger& logger = Logger::get("POCO Sample SMTP Logger");
		logger.setChannel(pSMTPChannel.get());
		logger.critical("Critical message");
	}
	catch (Exception& exc)
	{
		std::cerr << exc.displayText() << std::endl;
		return 1;
	}
	return 0;
}
