//
// MD2EngineTest.cpp
//
// $Id: //poco/svn/Foundation/testsuite/src/MD2EngineTest.cpp#2 $
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "MD2EngineTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/MD2Engine.h"


using Poco::MD2Engine;
using Poco::DigestEngine;


MD2EngineTest::MD2EngineTest(const std::string& name): CppUnit::TestCase(name)
{
}


MD2EngineTest::~MD2EngineTest()
{
}


void MD2EngineTest::testMD2()
{
	MD2Engine engine;

	// test vectors from RFC 1319

	engine.update("");
	assert (DigestEngine::digestToHex(engine.digest()) == "8350e5a3e24c153df2275c9f80692773");

	engine.update("a");
	assert (DigestEngine::digestToHex(engine.digest()) == "32ec01ec4a6dac72c0ab96fb34c0b5d1");

	engine.update("abc");
	assert (DigestEngine::digestToHex(engine.digest()) == "da853b0d3f88d99b30283a69e6ded6bb");

	engine.update("message digest");
	assert (DigestEngine::digestToHex(engine.digest()) == "ab4f496bfb2a530b219ff33031fe06b0");

	engine.update("abcdefghijklmnopqrstuvwxyz");
	assert (DigestEngine::digestToHex(engine.digest()) == "4e8ddff3650292ab5a4108c3aa47940b");
	
	engine.update("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	engine.update("abcdefghijklmnopqrstuvwxyz0123456789");
	assert (DigestEngine::digestToHex(engine.digest()) == "da33def2a42df13975352846c30338cd");

	engine.update("12345678901234567890123456789012345678901234567890123456789012345678901234567890");
	assert (DigestEngine::digestToHex(engine.digest()) == "d5976f79d83d3a0dc9806c3c66f3efd8");
}


void MD2EngineTest::setUp()
{
}


void MD2EngineTest::tearDown()
{
}


CppUnit::Test* MD2EngineTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("MD2EngineTest");

	CppUnit_addTest(pSuite, MD2EngineTest, testMD2);

	return pSuite;
}
