//
// DigestEngine.cpp
//
// $Id: //poco/Main/Foundation/src/DigestEngine.cpp#11 $
//
// Library: Foundation
// Package: Crypt
// Module:  DigestEngine
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/DigestEngine.h"
#include "Poco/Exception.h"


namespace Poco {


DigestEngine::DigestEngine()
{
}


DigestEngine::~DigestEngine()
{
}


std::string DigestEngine::digestToHex(const Digest& bytes)
{
	static const char digits[] = "0123456789abcdef";
	std::string result;
	result.reserve(bytes.size()*2);
	for (Digest::const_iterator it = bytes.begin(); it != bytes.end(); ++it)
	{
		unsigned char c = *it;
		result += digits[(c >> 4) & 0xF];
		result += digits[c & 0xF];
	}
	return result;
}


DigestEngine::Digest DigestEngine::digestFromHex(const std::string& digest)
{
	if (digest.size() % 2 != 0)
		throw DataFormatException();
	Digest result;
	result.reserve(digest.size()/2);
	for (std::size_t i = 0; i < digest.size(); ++i)
	{
		int c = 0;
		// first upper 4 bits
		if (digest[i] >= '0' && digest[i] <= '9')
			c = digest[i] - '0';
		else if (digest[i] >= 'a' && digest[i] <= 'f')
			c = digest[i] - 'a'+10;
		else if (digest[i] >= 'A' && digest[i] <= 'F')
			c = digest[i] - 'A'+10;
		else
			throw DataFormatException();
		c <<= 4;
		++i;
		if (digest[i] >= '0' && digest[i] <= '9')
			c += digest[i] - '0';
		else if (digest[i] >= 'a' && digest[i] <= 'f')
			c += digest[i] - 'a'+10;
		else if (digest[i] >= 'A' && digest[i] <= 'F')
			c += digest[i] - 'A'+10;
		else
			throw DataFormatException();

		result.push_back(static_cast<unsigned char>(c));
	}
	return result;
}


} // namespace Poco
