//
// RowFormatter.cpp
//
// $Id: //poco/Main/Data/src/RowFormatter.cpp#1 $
//
// Library: Data
// Package: DataCore
// Module:  RowFormatter
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/SimpleRowFormatter.h"
#include "Poco/Exception.h"
#include <iomanip>


namespace Poco {
namespace Data {


SimpleRowFormatter::SimpleRowFormatter(std::streamsize columnWidth):
	_colWidth(columnWidth)
{
}


SimpleRowFormatter::SimpleRowFormatter(const SimpleRowFormatter& other):
	RowFormatter(other.prefix(), other.postfix()),
	_colWidth(other._colWidth)
{
}


SimpleRowFormatter::~SimpleRowFormatter()
{
}


SimpleRowFormatter& SimpleRowFormatter::operator = (const SimpleRowFormatter& row)
{
	SimpleRowFormatter tmp(row);
	swap(tmp);
	return *this;
}


void SimpleRowFormatter::swap(SimpleRowFormatter& other)
{
	using std::swap;

	setPrefix(other.prefix());
	setPostfix(other.postfix());
	swap(_colWidth, other._colWidth);
}


std::string& SimpleRowFormatter::formatNames(const NameVecPtr pNames, std::string& formattedNames) const
{
	std::ostringstream str;
	std::string line(_colWidth * pNames->size(), '-');

	NameVec::const_iterator it = pNames->begin();
	NameVec::const_iterator end = pNames->end();
	for (; it != end; ++it)
	{
		str << std::left << std::setw(_colWidth) << *it;
	}
	str << std::endl << line << std::endl;

	return formattedNames = str.str();
}


std::string& SimpleRowFormatter::formatValues(const ValueVec& vals, std::string& formattedValues) const
{
	std::ostringstream str;

	ValueVec::const_iterator it = vals.begin();
	ValueVec::const_iterator end = vals.end();
	for (; it != end; ++it)
	{
		if (it->isNumeric())
		{
			str << std::right 
				<< std::fixed
				<< std::setprecision(2);
		}
		else str << std::left;

		str << std::setw(_colWidth) << it->convert<std::string>();
	}
	str << std::endl;

	return formattedValues = str.str();
}


} } // namespace Poco::Data
