//
// Preparation.h
//
// $Id: //poco/Main/Data/include/Poco/Data/Preparation.h#8 $
//
// Library: Data
// Package: DataCore
// Module:  Preparation
//
// Definition of the Preparation class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_Preparation_INCLUDED
#define Data_Preparation_INCLUDED


#include "Poco/Data/Data.h"
#include "Poco/Data/AbstractPreparation.h"
#include "Poco/Data/TypeHandler.h"
#include <cstddef>
#include <vector>


namespace Poco {
namespace Data {


template<typename T>
class Preparation: public AbstractPreparation
	/// Class for calling the appropriate AbstractPreparator method.
{
public:
	Preparation(AbstractPreparator* pPreparator, std::size_t pos, T& val): 
		AbstractPreparation(pPreparator), 
		_pos(pos), 
		_val(val)
		/// Creates the Preparation.
	{
	}

	~Preparation()
		/// Destroys the Preparation.
	{
	}

	void prepare()
		/// Preparations data.
	{
		TypeHandler<T>::prepare(_pos, _val, preparation());
	}

private:
	std::size_t _pos;
	T&          _val;
};


template<typename T>
class Preparation<std::vector<T> >: public AbstractPreparation
	/// Preparation specialization for std::vector.
	/// This specialization is needed for bulk operations to enforce
	/// the whole vector preparation, rather than only individual contained values.
{
public:
	Preparation(AbstractPreparator* pPreparator, std::size_t pos, std::vector<T>& val = std::vector<T>()): 
		AbstractPreparation(pPreparator), 
		_pos(pos), 
		_val(val)
		/// Creates the Preparation.
	{
	}

	~Preparation()
		/// Destroys the Preparation.
	{
	}

	void prepare()
		/// Preparations data.
	{
		TypeHandler<std::vector<T> >::prepare(_pos, _val, preparation());
	}

private:
	std::size_t     _pos;
	std::vector<T>& _val;
};


template<typename T>
class Preparation<std::deque<T> >: public AbstractPreparation
	/// Preparation specialization for std::deque.
	/// This specialization is needed for bulk operations to enforce
	/// the whole deque preparation, rather than only individual contained values.
{
public:
	Preparation(AbstractPreparator* pPreparator, std::size_t pos, std::deque<T>& val = std::deque<T>()): 
		AbstractPreparation(pPreparator), 
		_pos(pos), 
		_val(val)
		/// Creates the Preparation.
	{
	}

	~Preparation()
		/// Destroys the Preparation.
	{
	}

	void prepare()
		/// Preparations data.
	{
		TypeHandler<std::deque<T> >::prepare(_pos, _val, preparation());
	}

private:
	std::size_t     _pos;
	std::deque<T>&  _val;
};


template<typename T>
class Preparation<std::list<T> >: public AbstractPreparation
	/// Preparation specialization for std::list.
	/// This specialization is needed for bulk operations to enforce
	/// the whole list preparation, rather than only individual contained values.
{
public:
	Preparation(AbstractPreparator* pPreparator, std::size_t pos, std::list<T>& val = std::list<T>()): 
		AbstractPreparation(pPreparator), 
		_pos(pos), 
		_val(val)
		/// Creates the Preparation.
	{
	}

	~Preparation()
		/// Destroys the Preparation.
	{
	}

	void prepare()
		/// Preparations data.
	{
		TypeHandler<std::list<T> >::prepare(_pos, _val, preparation());
	}

private:
	std::size_t   _pos;
	std::list<T>& _val;
};


} } // namespace Poco::Data


#endif // Data_Preparation_INCLUDED
