//
// MySQLException.cpp
//
// $Id: //poco/1.4/Data/MySQL/src/MySQLException.cpp#1 $
//
// Library: Data
// Package: MySQL
// Module:  MySQLException
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/MySQL/MySQLException.h"
#include <mysql.h>
#include <stdio.h>

namespace Poco {
namespace Data {
namespace MySQL {


MySQLException::MySQLException(const std::string& msg) : Poco::Data::DataException(std::string("[MySQL]: ") + msg)
{
}


MySQLException::MySQLException(const MySQLException& exc) : Poco::Data::DataException(exc)
{
}


MySQLException::~MySQLException() throw()
{
}


/////
//
// ConnectionException
//
/////


ConnectionException::ConnectionException(const std::string& msg) : MySQLException(msg)
{
}


ConnectionException::ConnectionException(const std::string& text, MYSQL* h) : MySQLException(compose(text, h))
{
}


std::string ConnectionException::compose(const std::string& text, MYSQL* h)
{
	std::string str;
	str += "[Comment]: ";
	str += text;
	str += "\t[mysql_error]: ";
	str += mysql_error(h);

	str += "\t[mysql_errno]: ";
	char buff[30];
	sprintf(buff, "%d", mysql_errno(h));
	str += buff;

	str += "\t[mysql_sqlstate]: ";
	str += mysql_sqlstate(h);
	return str;
}


/////
//
// TransactionException
//
/////


TransactionException::TransactionException(const std::string& msg) : ConnectionException(msg)
{
}


TransactionException::TransactionException(const std::string& text, MYSQL* h) : ConnectionException(text, h)
{
}


/////
//
// StatementException
//
/////


StatementException::StatementException(const std::string& msg) : MySQLException(msg)
{
}


StatementException::StatementException(const std::string& text, MYSQL_STMT* h, const std::string& stmt) : MySQLException(compose(text, h, stmt))
{
}


std::string StatementException::compose(const std::string& text, MYSQL_STMT* h, const std::string& stmt)
{
	std::string str;
	str += "[Comment]: ";
	str += text;

	if (h != 0)
	{
		str += "\t[mysql_stmt_error]: ";
		str += mysql_stmt_error(h);

		str += "\t[mysql_stmt_errno]: ";
		char buff[30];
		sprintf(buff, "%d", mysql_stmt_errno(h));
		str += buff;

		str += "\t[mysql_stmt_sqlstate]: ";
		str += mysql_stmt_sqlstate(h);
	}

	if (stmt.length() > 0)
	{
		str += "\t[statemnt]: ";
		str += stmt;
	}

	return str;
}

} } } // namespace Poco::Data::MySQL
