//
// RSAKeyImpl.h
//
// $Id: //poco/Main/Crypto/include/Poco/Crypto/RSAKeyImpl.h#2 $
//
// Library: Crypto
// Package: CryptoCore
// Module:  RSAKeyImpl
//
// Definition of the RSAKeyImpl class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Crypto_RSAKeyImplImpl_INCLUDED
#define Crypto_RSAKeyImplImpl_INCLUDED


#include "Poco/Crypto/Crypto.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"


struct rsa_st;
typedef struct rsa_st RSA;


namespace Poco {
	namespace Net {
		class X509Certificate;
	}
namespace Crypto {


class RSAKeyImpl: public Poco::RefCountedObject
	/// class RSAKeyImpl
{
public:
	typedef Poco::AutoPtr<RSAKeyImpl> Ptr;

	RSAKeyImpl(const Poco::Net::X509Certificate& cert);
		/// Extracts the RSAKey from the certificate

	RSAKeyImpl(int keyLength, unsigned long exponent);
		/// Creates the RSAKeyImpl.

	RSAKeyImpl(const std::string& publicKey, const std::string& privateKeyFile, const std::string& privateKeyPwd);
		/// Creates the RSAKeyImpl.

	RSAKeyImpl(std::istream* pPubKey, std::istream* pPrivKey, const std::string& privateKeyPwd);
		/// Creates the RSAKeyImpl. privKey is an optional parameter which can be null.

	~RSAKeyImpl();
		/// Destroys the RSAKeyImpl.

	RSA* getRSA();
		/// Returns the openssl rsa object

	const RSA* getRSA() const;
		/// Returns the openssl rsa object

	int size() const;
		/// Returns the RSA_size

	void save(const std::string& pubKeyFile, const std::string& privKeyFile, const std::string& privKeyPwd);
		/// Exports the keys to the given files. privKeyFile can be empty

	void save(std::ostream* pPubKey, std::ostream* pPrivKey, const std::string& privateKeyPwd);
		/// Exports the keys to the given streams. Can be empty

private:
	void init(const std::string& pubKeyFile, const std::string& privKeyFile, const std::string& privKeyPwd);
		/// Initializes the object

	void freeRSA();
		// Deletes the RSA object
private:
	RSA* _pRSA;
};


inline RSA* RSAKeyImpl::getRSA()
{
	return _pRSA;
}


inline const RSA* RSAKeyImpl::getRSA() const
{
	return _pRSA;
}

} } // namespace Poco::Crypto


#endif // Crypto_RSAKeyImplImpl_INCLUDED
